/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.tuple.Triple;

public class TripleTable<L, M, R>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<L> lefts;
    private final List<M> middles;
    private final List<R> rights;

    public TripleTable(List<Triple<L, M, R>> triples) {
        this(Assert.notNull(triples).size());
        for (Triple<L, M, R> triple : triples) {
            this.put(triple.getLeft(), triple.getMiddle(), triple.getRight());
        }
    }

    public TripleTable(int size) {
        this(new ArrayList(size), new ArrayList(size), new ArrayList(size));
    }

    public TripleTable(List<L> lefts, List<M> middles, List<R> rights) {
        Assert.notNull(lefts);
        Assert.notNull(middles);
        Assert.notNull(rights);
        int size = lefts.size();
        if (size != middles.size() || size != rights.size()) {
            throw new IllegalArgumentException("List size must be equals!");
        }
        this.lefts = lefts;
        this.middles = middles;
        this.rights = rights;
    }

    public L getLeftByMiddle(M mValue) {
        int index = this.middles.indexOf(mValue);
        if (index > -1) {
            return this.lefts.get(index);
        }
        return null;
    }

    public L getLeftByRight(R rValue) {
        int index = this.rights.indexOf(rValue);
        if (index > -1) {
            return this.lefts.get(index);
        }
        return null;
    }

    public M getMiddleByLeft(L lValue) {
        int index = this.lefts.indexOf(lValue);
        if (index > -1) {
            return this.middles.get(index);
        }
        return null;
    }

    public M getMiddleByRight(R rValue) {
        int index = this.rights.indexOf(rValue);
        if (index > -1) {
            return this.middles.get(index);
        }
        return null;
    }

    public L getLeft(int index) {
        return this.lefts.get(index);
    }

    public M getMiddle(int index) {
        return this.middles.get(index);
    }

    public R getRight(int index) {
        return this.rights.get(index);
    }

    public R getRightByLeft(L lValue) {
        int index = this.lefts.indexOf(lValue);
        if (index > -1) {
            return this.rights.get(index);
        }
        return null;
    }

    public R getRightByMiddle(M mValue) {
        int index = this.middles.indexOf(mValue);
        if (index > -1) {
            return this.rights.get(index);
        }
        return null;
    }

    public boolean containLeft(L left) {
        return this.lefts.contains(left);
    }

    public boolean containMiddle(M middle) {
        return this.middles.contains(middle);
    }

    public boolean containRight(R right) {
        return this.rights.contains(right);
    }

    public int indexOfLeft(L left) {
        return this.lefts.indexOf(left);
    }

    public int indexOfMiddle(M middle) {
        return this.middles.indexOf(middle);
    }

    public int indexOfRight(R right) {
        return this.rights.indexOf(right);
    }

    public Triple<L, M, R> getByLeft(L lValue) {
        int index = this.lefts.indexOf(lValue);
        if (index > -1) {
            return new Triple<L, M, R>(this.lefts.get(index), this.middles.get(index), this.rights.get(index));
        }
        return null;
    }

    public Triple<L, M, R> getByMiddle(M mValue) {
        int index = this.middles.indexOf(mValue);
        if (index > -1) {
            return new Triple<L, M, R>(this.lefts.get(index), this.middles.get(index), this.rights.get(index));
        }
        return null;
    }

    public Triple<L, M, R> getByRight(R rValue) {
        int index = this.rights.indexOf(rValue);
        if (index > -1) {
            return new Triple<L, M, R>(this.lefts.get(index), this.middles.get(index), this.rights.get(index));
        }
        return null;
    }

    public List<L> getLefts() {
        return ListUtil.view(this.lefts);
    }

    public List<M> getMiddles() {
        return ListUtil.view(this.middles);
    }

    public List<R> getRights() {
        return ListUtil.view(this.rights);
    }

    public int size() {
        return this.lefts.size();
    }

    public TripleTable<L, M, R> put(L lValue, M mValue, R rValue) {
        this.lefts.add(lValue);
        this.middles.add(mValue);
        this.rights.add(rValue);
        return this;
    }

    public TripleTable<L, M, R> setLeft(int index, L lValue) {
        this.lefts.set(index, lValue);
        return this;
    }

    public TripleTable<L, M, R> setMiddle(int index, M mValue) {
        this.middles.set(index, mValue);
        return this;
    }

    public TripleTable<L, M, R> setRight(int index, R rValue) {
        this.rights.set(index, rValue);
        return this;
    }

    public TripleTable<L, M, R> clear() {
        this.lefts.clear();
        this.middles.clear();
        this.rights.clear();
        return this;
    }

    public TripleTable<L, M, R> remove(int index) {
        this.lefts.remove(index);
        this.middles.remove(index);
        this.rights.remove(index);
        return this;
    }
}

