/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.stream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.lang.tuple.Pair;
import org.dromara.hutool.core.lang.tuple.Triple;
import org.dromara.hutool.core.stream.EasyStream;
import org.dromara.hutool.core.stream.EntryStream;
import org.dromara.hutool.core.stream.SimpleCollector;

public class CollectorUtil {
    public static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    public static final Set<Collector.Characteristics> CH_NOID = Collections.emptySet();

    public static <T> Collector<T, ?, String> joining(CharSequence delimiter) {
        return CollectorUtil.joining(delimiter, Object::toString);
    }

    public static <T> Collector<T, ?, String> joining(CharSequence delimiter, Function<T, ? extends CharSequence> toStringFunc) {
        return CollectorUtil.joining(delimiter, "", "", toStringFunc);
    }

    public static <T> Collector<T, ?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix, Function<T, ? extends CharSequence> toStringFunc) {
        return new SimpleCollector<Object, StringJoiner, String>(() -> new StringJoiner(delimiter, prefix, suffix), (joiner, ele) -> joiner.add((CharSequence)toStringFunc.apply(ele)), StringJoiner::merge, StringJoiner::toString, Collections.emptySet());
    }

    public static <T, K, D, A, M extends Map<K, D>> Collector<T, ?, M> groupingBy(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BiConsumer<Map, Object> accumulator = (m, t) -> {
            Object key = Optional.ofNullable(t).map(classifier).orElse(null);
            Object container = m.computeIfAbsent(key, arg_0 -> CollectorUtil.lambda$null$2((Supplier)downstreamSupplier, arg_0));
            if (ArrayUtil.isArray(container) || Objects.nonNull(t)) {
                downstreamAccumulator.accept(container, t);
            }
        };
        BinaryOperator<M> merger = CollectorUtil.mapMerger(downstream.combiner());
        Supplier<M> mangledFactory = mapFactory;
        if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new SimpleCollector(mangledFactory, accumulator, merger, CH_ID);
        }
        Function downstreamFinisher = downstream.finisher();
        Function<Map, Map> finisher = intermediate -> {
            intermediate.replaceAll((k, v) -> downstreamFinisher.apply(v));
            Map castResult = intermediate;
            return castResult;
        };
        return new SimpleCollector<Object, Map, Map>(mangledFactory, accumulator, merger, finisher, CH_NOID);
    }

    public static <T, K, A, D> Collector<T, ?, Map<K, D>> groupingBy(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return CollectorUtil.groupingBy(classifier, HashMap::new, downstream);
    }

    public static <T, K> Collector<T, ?, Map<K, List<T>>> groupingBy(Function<? super T, ? extends K> classifier) {
        return CollectorUtil.groupingBy(classifier, Collectors.toList());
    }

    public static <T, K, R, C extends Collection<R>, M extends Map<K, C>> Collector<T, ?, M> groupingBy(Function<? super T, ? extends K> classifier, Function<? super T, ? extends R> valueMapper, Supplier<C> valueCollFactory, Supplier<M> mapFactory) {
        return CollectorUtil.groupingBy(classifier, mapFactory, Collectors.mapping(valueMapper, Collectors.toCollection(valueCollFactory)));
    }

    public static <T, K, R, C extends Collection<R>> Collector<T, ?, Map<K, C>> groupingBy(Function<? super T, ? extends K> classifier, Function<? super T, ? extends R> valueMapper, Supplier<C> valueCollFactory) {
        return CollectorUtil.groupingBy(classifier, valueMapper, valueCollFactory, HashMap::new);
    }

    public static <T, K, R> Collector<T, ?, Map<K, List<R>>> groupingBy(Function<? super T, ? extends K> classifier, Function<? super T, ? extends R> valueMapper) {
        return CollectorUtil.groupingBy(classifier, valueMapper, ArrayList::new, HashMap::new);
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return CollectorUtil.toMap(keyMapper, valueMapper, (l, r) -> r);
    }

    public static <T, K> Collector<T, ?, Map<K, T>> toMap(Function<? super T, ? extends K> keyMapper) {
        return CollectorUtil.toMap(keyMapper, Function.identity());
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return CollectorUtil.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        BiConsumer<Map, Object> accumulator = (map, element) -> map.put(Optional.ofNullable(element).map(keyMapper).orElse(null), Optional.ofNullable(element).map(valueMapper).orElse(null));
        return new SimpleCollector(mapSupplier, accumulator, CollectorUtil.mapMerger(mergeFunction), CH_ID);
    }

    public static <K, V, M extends Map<K, V>> BinaryOperator<M> mapMerger(BinaryOperator<V> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                m1.merge(e.getKey(), e.getValue(), mergeFunction);
            }
            return m1;
        };
    }

    public static <K, V> Collector<Map<K, V>, ?, Map<K, List<V>>> reduceListMap() {
        return CollectorUtil.reduceListMap(HashMap::new);
    }

    public static <K, V, R extends Map<K, List<V>>> Collector<Map<K, V>, ?, R> reduceListMap(Supplier<R> mapSupplier) {
        return Collectors.reducing(mapSupplier.get(), value -> {
            Map result = (Map)mapSupplier.get();
            value.forEach((k, v) -> result.computeIfAbsent(k, i -> new ArrayList()).add(v));
            return result;
        }, (l, r) -> {
            Map resultMap = (Map)mapSupplier.get();
            resultMap.putAll(l);
            r.forEach((k, v) -> resultMap.computeIfAbsent(k, i -> new ArrayList()).addAll(v));
            return resultMap;
        });
    }

    public static <T, K> Collector<T, List<T>, EntryStream<K, T>> toEntryStream(Function<? super T, ? extends K> keyMapper) {
        return CollectorUtil.toEntryStream(keyMapper, Function.identity());
    }

    public static <T, K, V> Collector<T, List<T>, EntryStream<K, V>> toEntryStream(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valueMapper);
        return CollectorUtil.transform(ArrayList::new, list -> EntryStream.of(list, keyMapper, valueMapper));
    }

    public static <T> Collector<T, ?, EasyStream<T>> toEasyStream() {
        return CollectorUtil.transform(ArrayList::new, EasyStream::of);
    }

    public static <T, R, C extends Collection<T>> Collector<T, C, R> transform(Supplier<C> collFactory, Function<C, R> mapper) {
        Objects.requireNonNull(collFactory);
        Objects.requireNonNull(mapper);
        return new SimpleCollector<Object, Collection, R>(collFactory, Collection::add, (l1, l2) -> {
            l1.addAll(l2);
            return l1;
        }, mapper, CH_NOID);
    }

    public static <T, R> Collector<T, List<T>, R> transform(Function<List<T>, R> mapper) {
        return CollectorUtil.transform(ArrayList::new, mapper);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> entryToMap() {
        return CollectorUtil.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T, A, R> Collector<T, ?, R> filtering(Predicate<? super T> predicate, Collector<? super T, A, R> downstream) {
        BiConsumer downstreamAccumulator = downstream.accumulator();
        return new SimpleCollector<Object, Object, R>(downstream.supplier(), (r, t) -> Optional.of(t).filter(predicate).ifPresent(e -> downstreamAccumulator.accept(r, e)), downstream.combiner(), downstream.finisher(), downstream.characteristics());
    }

    public static <T, L, R> Collector<T, ?, Pair<List<L>, List<R>>> toPairList(Function<? super T, ? extends L> lMapper, Function<? super T, ? extends R> rMapper) {
        return CollectorUtil.toPair(lMapper, rMapper, Collectors.toList(), Collectors.toList());
    }

    public static <T, LU, LA, LR, RU, RA, RR> Collector<T, ?, Pair<LR, RR>> toPair(Function<? super T, ? extends LU> lMapper, Function<? super T, ? extends RU> rMapper, Collector<? super LU, LA, LR> lDownstream, Collector<? super RU, RA, RR> rDownstream) {
        return new SimpleCollector<Object, Pair, Pair>(() -> Pair.of(lDownstream.supplier().get(), rDownstream.supplier().get()), (listPair, element) -> {
            lDownstream.accumulator().accept(listPair.getLeft(), lMapper.apply(element));
            rDownstream.accumulator().accept(listPair.getRight(), rMapper.apply(element));
        }, (listPair1, listPair2) -> Pair.of(lDownstream.combiner().apply(listPair1.getLeft(), listPair2.getLeft()), rDownstream.combiner().apply(listPair1.getRight(), listPair2.getRight())), finisherPair -> {
            Object finisherLeftValue = lDownstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH) ? finisherPair.getLeft() : lDownstream.finisher().apply(finisherPair.getLeft());
            Object finisherRightValue = lDownstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH) ? finisherPair.getRight() : rDownstream.finisher().apply(finisherPair.getRight());
            return Pair.of(finisherLeftValue, finisherRightValue);
        }, CH_NOID);
    }

    public static <T, L, M, R> Collector<T, ?, Triple<List<L>, List<M>, List<R>>> toTripleList(Function<? super T, ? extends L> lMapper, Function<? super T, ? extends M> mMapper, Function<? super T, ? extends R> rMapper) {
        return CollectorUtil.toTriple(lMapper, mMapper, rMapper, Collectors.toList(), Collectors.toList(), Collectors.toList());
    }

    public static <T, LU, LA, LR, MU, MA, MR, RU, RA, RR> Collector<T, ?, Triple<LR, MR, RR>> toTriple(Function<? super T, ? extends LU> lMapper, Function<? super T, ? extends MU> mMapper, Function<? super T, ? extends RU> rMapper, Collector<? super LU, LA, LR> lDownstream, Collector<? super MU, MA, MR> mDownstream, Collector<? super RU, RA, RR> rDownstream) {
        return new SimpleCollector<Object, Triple, Triple>(() -> Triple.of(lDownstream.supplier().get(), mDownstream.supplier().get(), rDownstream.supplier().get()), (listTriple, element) -> {
            lDownstream.accumulator().accept(listTriple.getLeft(), lMapper.apply(element));
            mDownstream.accumulator().accept(listTriple.getMiddle(), mMapper.apply(element));
            rDownstream.accumulator().accept(listTriple.getRight(), rMapper.apply(element));
        }, (listTriple1, listTriple2) -> Triple.of(lDownstream.combiner().apply(listTriple1.getLeft(), listTriple2.getLeft()), mDownstream.combiner().apply(listTriple1.getMiddle(), listTriple2.getMiddle()), rDownstream.combiner().apply(listTriple1.getRight(), listTriple2.getRight())), finisherTriple -> {
            Object finisherLeftValue = lDownstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH) ? finisherTriple.getLeft() : lDownstream.finisher().apply(finisherTriple.getLeft());
            Object finisherMiddleValue = mDownstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH) ? finisherTriple.getMiddle() : mDownstream.finisher().apply(finisherTriple.getMiddle());
            Object finisherRightValue = lDownstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH) ? finisherTriple.getRight() : rDownstream.finisher().apply(finisherTriple.getRight());
            return Triple.of(finisherLeftValue, finisherMiddleValue, finisherRightValue);
        }, CH_NOID);
    }

    private static /* synthetic */ Object lambda$null$2(Supplier downstreamSupplier, Object k) {
        return downstreamSupplier.get();
    }
}

