/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.thread.lock;

import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.concurrent.locks.StampedLock;
import org.dromara.hutool.core.thread.lock.NoLock;
import org.dromara.hutool.core.thread.lock.SegmentLock;

public class LockUtil {
    private static final NoLock NO_LOCK = new NoLock();

    public static StampedLock createStampLock() {
        return new StampedLock();
    }

    public static ReentrantReadWriteLock createReadWriteLock(boolean fair) {
        return new ReentrantReadWriteLock(fair);
    }

    public static SegmentLock<Lock> createSegmentLock(int segments) {
        return SegmentLock.lock(segments);
    }

    public static SegmentLock<ReadWriteLock> createSegmentReadWriteLock(int segments) {
        return SegmentLock.readWriteLock(segments);
    }

    public static SegmentLock<Semaphore> createSegmentSemaphore(int segments, int permits) {
        return SegmentLock.semaphore(segments, permits);
    }

    public static SegmentLock<Lock> createLazySegmentLock(int segments) {
        return SegmentLock.lazyWeakLock(segments);
    }

    public static Lock getSegmentLock(int segments, Object key) {
        return SegmentLock.lock(segments).get(key);
    }

    public static Lock getSegmentReadLock(int segments, Object key) {
        return SegmentLock.readWriteLock(segments).get(key).readLock();
    }

    public static Lock getSegmentWriteLock(int segments, Object key) {
        return SegmentLock.readWriteLock(segments).get(key).writeLock();
    }

    public static Semaphore getSegmentSemaphore(int segments, int permits, Object key) {
        return SegmentLock.semaphore(segments, permits).get(key);
    }

    public static Lock getLazySegmentLock(int segments, Object key) {
        return SegmentLock.lazyWeakLock(segments).get(key);
    }

    public static NoLock getNoLock() {
        return NO_LOCK;
    }
}

