/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.thread.lock;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.lang.Assert;

public abstract class SegmentLock<L> {
    private static final int LARGE_LAZY_CUTOFF = 1024;
    private static final int ALL_SET = -1;

    private SegmentLock() {
    }

    public abstract L get(Object var1);

    public abstract L getAt(int var1);

    abstract int indexFor(Object var1);

    public abstract int size();

    public Iterable<L> bulkGet(Iterable<?> keys) {
        ArrayList<?> result = ListUtil.of(keys);
        if (CollUtil.isEmpty(result)) {
            return Collections.emptyList();
        }
        int[] stripes = new int[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            stripes[i] = this.indexFor(result.get(i));
        }
        Arrays.sort(stripes);
        int previousStripe = stripes[0];
        result.set(0, this.getAt(previousStripe));
        for (int i = 1; i < result.size(); ++i) {
            int currentStripe = stripes[i];
            if (currentStripe == previousStripe) {
                result.set(i, result.get(i - 1));
                continue;
            }
            result.set(i, this.getAt(currentStripe));
            previousStripe = currentStripe;
        }
        ArrayList<?> asStripes = result;
        return Collections.unmodifiableList(asStripes);
    }

    public static <L> SegmentLock<L> custom(int stripes, Supplier<L> supplier) {
        return new CompactSegmentLock<L>(stripes, supplier);
    }

    public static SegmentLock<Lock> lock(int stripes) {
        return SegmentLock.custom(stripes, PaddedLock::new);
    }

    public static SegmentLock<Lock> lazyWeakLock(int stripes) {
        return SegmentLock.lazyWeakCustom(stripes, () -> new ReentrantLock(false));
    }

    private static <L> SegmentLock<L> lazyWeakCustom(int stripes, Supplier<L> supplier) {
        return stripes < 1024 ? new SmallLazySegmentLock<L>(stripes, supplier) : new LargeLazySegmentLock<L>(stripes, supplier);
    }

    public static SegmentLock<Semaphore> semaphore(int stripes, int permits) {
        return SegmentLock.custom(stripes, () -> new PaddedSemaphore(permits));
    }

    public static SegmentLock<Semaphore> lazyWeakSemaphore(int stripes, int permits) {
        return SegmentLock.lazyWeakCustom(stripes, () -> new Semaphore(permits, false));
    }

    public static SegmentLock<ReadWriteLock> readWriteLock(int stripes) {
        return SegmentLock.custom(stripes, ReentrantReadWriteLock::new);
    }

    public static SegmentLock<ReadWriteLock> lazyWeakReadWriteLock(int stripes) {
        return SegmentLock.lazyWeakCustom(stripes, WeakSafeReadWriteLock::new);
    }

    private static int ceilToPowerOfTwo(int x) {
        return 1 << 32 - Integer.numberOfLeadingZeros(x - 1);
    }

    private static int smear(int hashCode) {
        hashCode ^= hashCode >>> 20 ^ hashCode >>> 12;
        return hashCode ^ hashCode >>> 7 ^ hashCode >>> 4;
    }

    private static class PaddedSemaphore
    extends Semaphore {
        private static final long serialVersionUID = 1L;
        long unused1;
        long unused2;
        long unused3;

        PaddedSemaphore(int permits) {
            super(permits, false);
        }
    }

    private static class PaddedLock
    extends ReentrantLock {
        private static final long serialVersionUID = 1L;
        long unused1;
        long unused2;
        long unused3;

        PaddedLock() {
            super(false);
        }
    }

    private static class LargeLazySegmentLock<L>
    extends PowerOfTwoSegmentLock<L> {
        final ConcurrentMap<Integer, L> locks;
        final Supplier<L> supplier;
        final int size;

        LargeLazySegmentLock(int stripes, Supplier<L> supplier) {
            super(stripes);
            this.size = this.mask == -1 ? Integer.MAX_VALUE : this.mask + 1;
            this.locks = new ConcurrentHashMap<Integer, L>();
            this.supplier = supplier;
        }

        @Override
        public L getAt(int index) {
            Object existing;
            if (this.size != Integer.MAX_VALUE) {
                Assert.isTrue(index >= 0 && index < this.size, "Index out of bounds", new Object[0]);
            }
            if ((existing = this.locks.get(index)) != null) {
                return (L)existing;
            }
            L created = this.supplier.get();
            existing = this.locks.putIfAbsent(index, created);
            return (L)(existing != null ? existing : created);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    private static class SmallLazySegmentLock<L>
    extends PowerOfTwoSegmentLock<L> {
        final AtomicReferenceArray<ArrayReference<? extends L>> locks;
        final Supplier<L> supplier;
        final int size;
        final ReferenceQueue<L> queue = new ReferenceQueue();

        SmallLazySegmentLock(int stripes, Supplier<L> supplier) {
            super(stripes);
            this.size = this.mask == -1 ? Integer.MAX_VALUE : this.mask + 1;
            this.locks = new AtomicReferenceArray(this.size);
            this.supplier = supplier;
        }

        @Override
        public L getAt(int index) {
            ArrayReference<? extends L> existingRef;
            L existing;
            if (this.size != Integer.MAX_VALUE) {
                Assert.isTrue(index >= 0 && index < this.size, "Index out of bounds", new Object[0]);
            }
            L l = existing = (existingRef = this.locks.get(index)) == null ? null : (L)existingRef.get();
            if (existing != null) {
                return existing;
            }
            L created = this.supplier.get();
            ArrayReference<L> newRef = new ArrayReference<L>(created, index, this.queue);
            while (!this.locks.compareAndSet(index, existingRef, newRef)) {
                existingRef = this.locks.get(index);
                existing = existingRef == null ? null : (L)existingRef.get();
                if (existing == null) continue;
                return existing;
            }
            this.drainQueue();
            return created;
        }

        private void drainQueue() {
            Reference<L> ref;
            while ((ref = this.queue.poll()) != null) {
                ArrayReference arrayRef = (ArrayReference)ref;
                this.locks.compareAndSet(arrayRef.index, arrayRef, null);
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        private static final class ArrayReference<L>
        extends WeakReference<L> {
            final int index;

            ArrayReference(L referent, int index, ReferenceQueue<L> queue) {
                super(referent, queue);
                this.index = index;
            }
        }
    }

    private static class CompactSegmentLock<L>
    extends PowerOfTwoSegmentLock<L> {
        private final Object[] array;

        CompactSegmentLock(int stripes, Supplier<L> supplier) {
            super(stripes);
            Assert.isTrue(stripes <= 0x3FFFFFFF, "Segment count must be <= 2^30", new Object[0]);
            this.array = new Object[this.mask + 1];
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = supplier.get();
            }
        }

        @Override
        public L getAt(int index) {
            if (index < 0 || index >= this.array.length) {
                throw new IllegalArgumentException("Index " + index + " out of bounds for size " + this.array.length);
            }
            return (L)this.array[index];
        }

        @Override
        public int size() {
            return this.array.length;
        }
    }

    private static abstract class PowerOfTwoSegmentLock<L>
    extends SegmentLock<L> {
        final int mask;

        PowerOfTwoSegmentLock(int stripes) {
            Assert.isTrue(stripes > 0, "Segment count must be positive", new Object[0]);
            this.mask = stripes > 0x3FFFFFFF ? -1 : SegmentLock.ceilToPowerOfTwo(stripes) - 1;
        }

        @Override
        final int indexFor(Object key) {
            int hash = SegmentLock.smear(key.hashCode());
            return hash & this.mask;
        }

        @Override
        public final L get(Object key) {
            return this.getAt(this.indexFor(key));
        }
    }

    private static final class WeakSafeCondition
    implements Condition {
        private final Condition delegate;
        private final WeakSafeReadWriteLock strongReference;

        WeakSafeCondition(Condition delegate, WeakSafeReadWriteLock strongReference) {
            this.delegate = delegate;
            this.strongReference = strongReference;
        }

        @Override
        public void await() throws InterruptedException {
            this.delegate.await();
        }

        @Override
        public void awaitUninterruptibly() {
            this.delegate.awaitUninterruptibly();
        }

        @Override
        public long awaitNanos(long nanosTimeout) throws InterruptedException {
            return this.delegate.awaitNanos(nanosTimeout);
        }

        @Override
        public boolean await(long time, TimeUnit unit) throws InterruptedException {
            return this.delegate.await(time, unit);
        }

        @Override
        public boolean awaitUntil(Date deadline) throws InterruptedException {
            return this.delegate.awaitUntil(deadline);
        }

        @Override
        public void signal() {
            this.delegate.signal();
        }

        @Override
        public void signalAll() {
            this.delegate.signalAll();
        }
    }

    private static final class WeakSafeLock
    implements Lock {
        private final Lock delegate;
        private final WeakSafeReadWriteLock strongReference;

        WeakSafeLock(Lock delegate, WeakSafeReadWriteLock strongReference) {
            this.delegate = delegate;
            this.strongReference = strongReference;
        }

        @Override
        public void lock() {
            this.delegate.lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            this.delegate.lockInterruptibly();
        }

        @Override
        public boolean tryLock() {
            return this.delegate.tryLock();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            return this.delegate.tryLock(time, unit);
        }

        @Override
        public void unlock() {
            this.delegate.unlock();
        }

        @Override
        public Condition newCondition() {
            return new WeakSafeCondition(this.delegate.newCondition(), this.strongReference);
        }
    }

    private static final class WeakSafeReadWriteLock
    implements ReadWriteLock {
        private final ReadWriteLock delegate = new ReentrantReadWriteLock();

        WeakSafeReadWriteLock() {
        }

        @Override
        public Lock readLock() {
            return new WeakSafeLock(this.delegate.readLock(), this);
        }

        @Override
        public Lock writeLock() {
            return new WeakSafeLock(this.delegate.writeLock(), this);
        }
    }
}

