/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.thread.ratelimiter;

import java.util.concurrent.Semaphore;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.thread.ratelimiter.RateLimiter;
import org.dromara.hutool.core.thread.ratelimiter.RateLimiterConfig;

public abstract class SemaphoreRateLimiter
implements RateLimiter {
    protected final RateLimiterConfig config;
    protected final Semaphore semaphore;

    public SemaphoreRateLimiter(RateLimiterConfig config) {
        this(config, null);
    }

    public SemaphoreRateLimiter(RateLimiterConfig config, Semaphore semaphore) {
        this.config = Assert.notNull(config);
        this.semaphore = Opt.ofNullable(semaphore).orElseGet(() -> new Semaphore(config.getCapacity()));
    }

    @Override
    public boolean tryAcquire(int permits) {
        return this.semaphore.tryAcquire(permits);
    }

    @Override
    public void acquire(int permits) {
        this.semaphore.acquireUninterruptibly(permits);
    }

    public abstract void refreshLimit();
}

