/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.xml;

import java.io.File;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.core.xml.XXEUtil;
import org.w3c.dom.Node;

public class XmlWriter {
    private final Source source;
    private Charset charset = CharsetUtil.UTF_8;
    private int indent;
    private boolean omitXmlDeclaration;

    public static XmlWriter of(Node node) {
        return XmlWriter.of(new DOMSource(node));
    }

    public static XmlWriter of(Source source) {
        return new XmlWriter(source);
    }

    public XmlWriter(Source source) {
        this.source = source;
    }

    public XmlWriter setCharset(Charset charset) {
        if (null != charset) {
            this.charset = charset;
        }
        return this;
    }

    public XmlWriter setIndent(int indent) {
        this.indent = indent;
        return this;
    }

    public XmlWriter setOmitXmlDeclaration(boolean omitXmlDeclaration) {
        this.omitXmlDeclaration = omitXmlDeclaration;
        return this;
    }

    public String getStr() {
        StringWriter writer = StrUtil.getWriter();
        this.write(writer);
        return writer.toString();
    }

    public void write(File file) {
        this.write(new StreamResult(file));
    }

    public void write(Writer writer) {
        this.write(new StreamResult(writer));
    }

    public void write(OutputStream out) {
        this.write(new StreamResult(out));
    }

    public void write(Result result) {
        TransformerFactory factory = XXEUtil.disableXXE(TransformerFactory.newInstance());
        try {
            Transformer xformer = factory.newTransformer();
            if (this.indent > 0) {
                xformer.setOutputProperty("indent", "yes");
                xformer.setOutputProperty("doctype-public", "yes");
                xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(this.indent));
            }
            if (ObjUtil.isNotNull(this.charset)) {
                xformer.setOutputProperty("encoding", this.charset.name());
            }
            if (this.omitXmlDeclaration) {
                xformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            xformer.transform(this.source, result);
        }
        catch (Exception e) {
            throw new HutoolException(e, "Trans xml document to string error!", new Object[0]);
        }
    }
}

