/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto;

import java.util.Arrays;
import org.dromara.hutool.crypto.CipherMode;

public interface Cipher {
    public String getAlgorithmName();

    public int getBlockSize();

    public void init(CipherMode var1, Parameters var2);

    public int getOutputSize(int var1);

    public int process(byte[] var1, int var2, int var3, byte[] var4, int var5);

    public int doFinal(byte[] var1, int var2);

    default public byte[] processFinal(byte[] in) {
        return this.processFinal(in, 0, in.length);
    }

    default public byte[] processFinal(byte[] in, int inOffset, int inputLen) {
        byte[] buf = new byte[this.getOutputSize(in.length)];
        int len = this.process(in, inOffset, inputLen, buf, 0);
        return (len += this.doFinal(buf, len)) == buf.length ? buf : Arrays.copyOfRange(buf, 0, len);
    }

    public static interface Parameters {
    }
}

