/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.c3p0;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.config.ConnectionConfig;
import org.dromara.hutool.db.ds.AbstractDSFactory;
import org.dromara.hutool.setting.props.Props;

public class C3p0DSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = 1L;

    public C3p0DSFactory() {
        super(ComboPooledDataSource.class, "C3P0");
    }

    @Override
    public DataSource createDataSource(ConnectionConfig<?> config) {
        ComboPooledDataSource ds = new ComboPooledDataSource();
        ds.setJdbcUrl(config.getUrl());
        try {
            ds.setDriverClass(config.getDriver());
        }
        catch (PropertyVetoException e) {
            throw new DbException(e);
        }
        ds.setUser(config.getUser());
        ds.setPassword(config.getPass());
        Props.of(config.getPoolProps()).toBean(ds);
        Properties connProps = config.getConnProps();
        if (MapUtil.isNotEmpty(connProps)) {
            ds.getProperties().putAll((Map<?, ?>)connProps);
        }
        return ds;
    }
}

