/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.engine.sun.filter;

import org.dromara.hutool.core.exception.ExceptionUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.http.server.engine.sun.SunServerRequest;
import org.dromara.hutool.http.server.engine.sun.SunServerResponse;
import org.dromara.hutool.http.server.engine.sun.filter.ExceptionFilter;

public class DefaultExceptionFilter
extends ExceptionFilter {
    private static final String TEMPLATE_ERROR = "<!DOCTYPE html><html><head><title>Hutool - Error report</title><style>h1,h3 {color:white; background-color: gray;}</style></head><body><h1>HTTP Status {} - {}</h1><hr size=\"1\" noshade=\"noshade\" /><p>{}</p><hr size=\"1\" noshade=\"noshade\" /><h3>Hutool</h3></body></html>";

    @Override
    public void afterException(SunServerRequest req, SunServerResponse res, Throwable e) {
        String content = ExceptionUtil.stacktraceToString(e);
        content = content.replace("\n", "<br/>\n");
        content = StrUtil.format(TEMPLATE_ERROR, 500, req.getURI(), content);
        res.sendError(500, content);
    }
}

