/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.server.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.http.server.handler.ServerRequest;
import org.dromara.hutool.http.server.servlet.ServletUtil;

public class ServletRequest
implements ServerRequest {
    private final HttpServletRequest request;

    public ServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public String getMethod() {
        return this.request.getMethod();
    }

    @Override
    public String getPath() {
        return this.request.getContextPath();
    }

    @Override
    public String getQuery() {
        return this.request.getQueryString();
    }

    public Map<String, String> getHeaderMap() {
        return ServletUtil.getHeaderMap(this.request);
    }

    public Map<String, List<String>> getHeadersMap() {
        return ServletUtil.getHeadersMap(this.request);
    }

    @Override
    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    @Override
    public InputStream getBodyStream() {
        try {
            return this.request.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

