/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.poi.excel.cell;

import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellBase;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.dromara.hutool.poi.excel.cell.CellUtil;
import org.dromara.hutool.poi.excel.cell.values.FormulaCellValue;

public class VirtualCell
extends CellBase {
    private final Row row;
    private final int columnIndex;
    private final int rowIndex;
    private CellType cellType;
    private Object value;
    private CellStyle style;
    private Comment comment;

    public VirtualCell(Cell cell, int x, int y) {
        this(cell.getRow(), x, y);
        this.cellType = cell.getCellType();
        this.value = CellUtil.getCellValue(cell);
        this.style = cell.getCellStyle();
        this.comment = cell.getCellComment();
    }

    public VirtualCell(Cell cell, int x, int y, Object value) {
        this(cell.getRow(), x, y);
        this.style = cell.getCellStyle();
        this.comment = cell.getCellComment();
        CellUtil.setCellValue((Cell)this, value);
    }

    public VirtualCell(Row row, int x, int y) {
        this.row = row;
        this.rowIndex = y;
        this.columnIndex = x;
    }

    protected void setCellTypeImpl(CellType cellType) {
        this.cellType = cellType;
    }

    protected void setCellFormulaImpl(String formula) {
        this.value = new FormulaCellValue(formula);
    }

    protected void removeFormulaImpl() {
        if (this.value instanceof FormulaCellValue) {
            this.value = null;
        }
    }

    protected void setCellValueImpl(double value) {
        this.cellType = CellType.NUMERIC;
        this.value = value;
    }

    protected void setCellValueImpl(Date value) {
        this.cellType = CellType.NUMERIC;
        this.value = value;
    }

    protected void setCellValueImpl(LocalDateTime value) {
        this.cellType = CellType.NUMERIC;
        this.value = value;
    }

    protected void setCellValueImpl(Calendar value) {
        this.cellType = CellType.NUMERIC;
        this.value = value;
    }

    protected void setCellValueImpl(String value) {
        this.cellType = CellType.STRING;
        this.value = value;
    }

    protected void setCellValueImpl(RichTextString value) {
        this.cellType = CellType.STRING;
        this.value = value;
    }

    protected SpreadsheetVersion getSpreadsheetVersion() {
        return SpreadsheetVersion.EXCEL2007;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Sheet getSheet() {
        return this.row.getSheet();
    }

    public Row getRow() {
        return this.row;
    }

    public CellType getCellType() {
        return this.cellType;
    }

    public CellType getCachedFormulaResultType() {
        if (this.value instanceof FormulaCellValue) {
            return ((FormulaCellValue)this.value).getResultType();
        }
        return null;
    }

    public String getCellFormula() {
        if (this.value instanceof FormulaCellValue) {
            return ((FormulaCellValue)this.value).getValue();
        }
        return null;
    }

    public double getNumericCellValue() {
        return (Double)this.value;
    }

    public Date getDateCellValue() {
        return (Date)this.value;
    }

    public LocalDateTime getLocalDateTimeCellValue() {
        return (LocalDateTime)this.value;
    }

    public RichTextString getRichStringCellValue() {
        return (RichTextString)this.value;
    }

    public String getStringCellValue() {
        return (String)this.value;
    }

    public void setCellValue(boolean value) {
        this.cellType = CellType.BOOLEAN;
        this.value = value;
    }

    public void setCellErrorValue(byte value) {
        this.cellType = CellType.ERROR;
        this.value = value;
    }

    public boolean getBooleanCellValue() {
        return (Boolean)this.value;
    }

    public byte getErrorCellValue() {
        return (Byte)this.value;
    }

    public void setCellStyle(CellStyle style) {
        this.style = style;
    }

    public CellStyle getCellStyle() {
        return this.style;
    }

    public void setAsActiveCell() {
        throw new UnsupportedOperationException("Virtual cell cannot be set as active cell");
    }

    public void setCellComment(Comment comment) {
        this.comment = comment;
    }

    public Comment getCellComment() {
        return this.comment;
    }

    public void removeCellComment() {
        this.comment = null;
    }

    public Hyperlink getHyperlink() {
        return (Hyperlink)this.value;
    }

    public void setHyperlink(Hyperlink link) {
        this.value = link;
    }

    public void removeHyperlink() {
        if (this.value instanceof Hyperlink) {
            this.value = null;
        }
    }

    public CellRangeAddress getArrayFormulaRange() {
        return null;
    }

    public boolean isPartOfArrayFormulaGroup() {
        return false;
    }
}

