/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.dromara.hutool.core.exception.ExceptionUtil;
import org.dromara.hutool.core.io.IORuntimeException;

public class FontUtil {
    public static Font[] getAllFonts() {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return e.getAllFonts();
    }

    public static void registerFont(Font font) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        ge.registerFont(font);
    }

    public static Font createFont() {
        return new Font(null);
    }

    public static Font createSansSerifFont(int size) {
        return FontUtil.createFont("SansSerif", size);
    }

    public static Font createFont(String name, int size) {
        return new Font(name, 0, size);
    }

    public static Font createFont(File fontFile) {
        try {
            return Font.createFont(0, fontFile);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontFile);
            }
            catch (Exception e1) {
                throw ExceptionUtil.wrapRuntime(e);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Font createFont(InputStream fontStream) {
        try {
            return Font.createFont(0, fontStream);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontStream);
            }
            catch (Exception e1) {
                throw ExceptionUtil.wrapRuntime(e1);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Dimension getDimension(FontMetrics metrics, String str) {
        int width = metrics.stringWidth(str);
        int height = metrics.getAscent() - metrics.getLeading() - metrics.getDescent();
        return new Dimension(width, height);
    }

    public static Rectangle2D getRectangle(String str, Font font) {
        return font.getStringBounds(str, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
    }
}

