/*
 * Copyright (c) 2023 looly(loolly@aliyun.com)
 * Hutool is licensed under Mulan PSL v2.
 * You can use this software according to the terms and conditions of the Mulan PSL v2.
 * You may obtain a copy of Mulan PSL v2 at:
 *          http://license.coscl.org.cn/MulanPSL2
 * THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
 * EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
 * MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
 * See the Mulan PSL v2 for more details.
 */

package org.dromara.hutool.poi.excel.cell;

import java.io.Serializable;
import java.util.Objects;

/**
 * 单元格位置
 *
 * @author Looly
 * @since 5.1.4
 */
public class CellLocation implements Serializable {
	private static final long serialVersionUID = 1L;

	private int x;
	private int y;

	/**
	 * 构造
	 *
	 * @param x 列号，从0开始
	 * @param y 行号，从0开始
	 */
	public CellLocation(final int x, final int y) {
		this.x = x;
		this.y = y;
	}

	/**
	 * 获取x（列）号
	 *
	 * @return x（列）号
	 */
	public int getX() {
		return x;
	}

	/**
	 * 设置x（列）号
	 *
	 * @param x x（列）号
	 */
	public void setX(final int x) {
		this.x = x;
	}

	/**
	 * 获取y（行）号
	 * @return y（行）号
	 */
	public int getY() {
		return y;
	}

	/**
	 * 设置y（行）号
	 * @param y y（行）号
	 */
	public void setY(final int y) {
		this.y = y;
	}

	@Override
	public boolean equals(final Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		final CellLocation that = (CellLocation) o;
		return x == that.x && y == that.y;
	}

	@Override
	public int hashCode() {
		return Objects.hash(x, y);
	}

	@Override
	public String toString() {
		return "CellLocation{" +
			"x=" + x +
			", y=" + y +
			'}';
	}
}
