/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.PropDesc;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.CaseInsensitiveMap;
import org.dromara.hutool.core.reflect.FieldUtil;
import org.dromara.hutool.core.reflect.ModifierUtil;
import org.dromara.hutool.core.reflect.method.MethodUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.BooleanUtil;

public class BeanDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> beanClass;
    private final Map<String, PropDesc> propMap = new LinkedHashMap<String, PropDesc>();

    public BeanDesc(Class<?> beanClass) {
        Assert.notNull(beanClass);
        this.beanClass = beanClass;
        this.init();
    }

    public String getName() {
        return this.beanClass.getName();
    }

    public String getSimpleName() {
        return this.beanClass.getSimpleName();
    }

    public Map<String, PropDesc> getPropMap(boolean ignoreCase) {
        return ignoreCase ? new CaseInsensitiveMap<String, PropDesc>(1.0f, this.propMap) : this.propMap;
    }

    public Collection<PropDesc> getProps() {
        return this.propMap.values();
    }

    public PropDesc getProp(String fieldName) {
        return this.propMap.get(fieldName);
    }

    public Field getField(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getField();
    }

    public Method getGetter(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getGetter();
    }

    public Method getSetter(String fieldName) {
        PropDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getSetter();
    }

    private void init() {
        Method[] gettersAndSetters = MethodUtil.getPublicMethods(this.beanClass, MethodUtil::isGetterOrSetterIgnoreCase);
        for (Field field : FieldUtil.getFields(this.beanClass)) {
            if (ModifierUtil.isStatic(field) || FieldUtil.isOuterClassField(field)) continue;
            PropDesc prop = this.createProp(field, gettersAndSetters);
            this.propMap.putIfAbsent(prop.getFieldName(), prop);
        }
    }

    private PropDesc createProp(Field field, Method[] methods) {
        PropDesc prop = this.findProp(field, methods, false);
        if (null == prop.getter || null == prop.setter) {
            PropDesc propIgnoreCase = this.findProp(field, methods, true);
            if (null == prop.getter) {
                prop.getter = propIgnoreCase.getter;
            }
            if (null == prop.setter) {
                prop.setter = propIgnoreCase.setter;
            }
        }
        return prop;
    }

    private PropDesc findProp(Field field, Method[] gettersOrSetters, boolean ignoreCase) {
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        boolean isBooleanField = BooleanUtil.isBoolean(fieldType);
        Method[] getterAndSetter = this.findGetterAndSetter(fieldName, fieldType, gettersOrSetters, ignoreCase);
        if (isBooleanField) {
            if (null == getterAndSetter[0]) {
                getterAndSetter[0] = this.findGetterForBoolean(fieldName, gettersOrSetters, ignoreCase);
            }
            if (null == getterAndSetter[1]) {
                getterAndSetter[1] = this.findSetterForBoolean(fieldName, gettersOrSetters, ignoreCase);
            }
        }
        return new PropDesc(field, getterAndSetter[0], getterAndSetter[1]);
    }

    private Method[] findGetterAndSetter(String fieldName, Class<?> fieldType, Method[] gettersOrSetters, boolean ignoreCase) {
        Method getter = null;
        Method setter = null;
        for (Method method : gettersOrSetters) {
            String methodName = method.getName();
            if (0 == method.getParameterCount()) {
                if (StrUtil.equals(methodName, StrUtil.genGetter(fieldName), ignoreCase) && method.getReturnType().isAssignableFrom(fieldType)) {
                    getter = method;
                }
            } else if (StrUtil.equals(methodName, StrUtil.genSetter(fieldName), ignoreCase) && fieldType.isAssignableFrom(method.getParameterTypes()[0])) {
                setter = method;
            }
            if (null != getter && null != setter) break;
        }
        return new Method[]{getter, setter};
    }

    private Method findGetterForBoolean(String fieldName, Method[] gettersOrSetters, boolean ignoreCase) {
        return ArrayUtil.get(gettersOrSetters, m -> {
            if (0 != m.getParameterCount() || !BooleanUtil.isBoolean(m.getReturnType())) {
                return false;
            }
            if (StrUtil.startWith(fieldName, "is", ignoreCase) && StrUtil.equals(fieldName, m.getName(), ignoreCase)) {
                return true;
            }
            return StrUtil.equals(StrUtil.upperFirstAndAddPre(fieldName, "is"), m.getName(), ignoreCase);
        });
    }

    private Method findSetterForBoolean(String fieldName, Method[] gettersOrSetters, boolean ignoreCase) {
        return ArrayUtil.get(gettersOrSetters, m -> {
            if (1 != m.getParameterCount() || !BooleanUtil.isBoolean(m.getParameterTypes()[0])) {
                return false;
            }
            if (StrUtil.startWith(fieldName, "is", ignoreCase)) {
                return StrUtil.equals("set" + StrUtil.removePrefix(fieldName, "is", ignoreCase), m.getName(), ignoreCase);
            }
            return false;
        });
    }
}

