/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.comparator;

import java.util.function.Function;
import org.dromara.hutool.core.comparator.ComparatorException;
import org.dromara.hutool.core.comparator.CompareUtil;
import org.dromara.hutool.core.comparator.NullComparator;

public class FuncComparator<T>
extends NullComparator<T> {
    private static final long serialVersionUID = 1L;
    private final Function<T, Comparable<?>> func;

    public FuncComparator(boolean nullGreater, Function<T, Comparable<?>> func) {
        super(nullGreater, null);
        this.func = func;
    }

    @Override
    protected int doCompare(T a, T b) {
        Comparable<?> v2;
        Comparable<?> v1;
        try {
            v1 = this.func.apply(a);
            v2 = this.func.apply(b);
        }
        catch (Exception e) {
            throw new ComparatorException(e);
        }
        return this.compare(a, b, v1, v2);
    }

    private int compare(T o1, T o2, Comparable v1, Comparable v2) {
        int result = CompareUtil.compare(v1, v2, this.nullGreater);
        if (0 == result) {
            result = CompareUtil.compare(o1, o2, this.nullGreater);
        }
        return result;
    }
}

