/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.stream;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.collection.iter.IterUtil;
import org.dromara.hutool.core.lang.Console;
import org.dromara.hutool.core.lang.mutable.MutableInt;
import org.dromara.hutool.core.lang.mutable.MutableObj;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.map.SafeConcurrentHashMap;
import org.dromara.hutool.core.stream.CollectorUtil;
import org.dromara.hutool.core.stream.EasyStream;
import org.dromara.hutool.core.stream.EntryStream;
import org.dromara.hutool.core.stream.StreamUtil;
import org.dromara.hutool.core.stream.TerminableWrappedStream;
import org.dromara.hutool.core.stream.WrappedStream;

public interface TransformableWrappedStream<T, S extends TransformableWrappedStream<T, S>>
extends WrappedStream<T, S> {
    default public <U, R> EasyStream<R> zip(Iterable<U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        Objects.requireNonNull(zipper);
        Map idxIdentityMap = this.mapIdx((e, idx) -> MapUtil.entry(idx, e)).collect(CollectorUtil.entryToMap());
        Map idxOtherMap = EasyStream.of(other).mapIdx((e, idx) -> MapUtil.entry(idx, e)).collect(CollectorUtil.entryToMap());
        if (idxIdentityMap.size() <= idxOtherMap.size()) {
            return EasyStream.of(idxIdentityMap.keySet(), this.isParallel()).map((T k) -> zipper.apply((Object)idxIdentityMap.get(k), (Object)idxOtherMap.get(k)));
        }
        return EasyStream.of(idxOtherMap.keySet(), this.isParallel()).map((T k) -> zipper.apply((Object)idxIdentityMap.get(k), (Object)idxOtherMap.get(k)));
    }

    default public EasyStream<EasyStream<T>> split(int batchSize) {
        List list = this.collect(Collectors.toList());
        int size = list.size();
        if (size <= batchSize) {
            return EasyStream.of(EasyStream.of(list, this.isParallel()));
        }
        return (EasyStream)((EasyStream)EasyStream.iterate(0, i -> i < size, i -> i + batchSize).map((T skip) -> EasyStream.of(list.subList((int)skip, Math.min(size, skip + batchSize)), this.isParallel())).parallel(this.isParallel())).onClose(this.unwrap()::close);
    }

    default public EasyStream<List<T>> splitList(int batchSize) {
        return this.split(batchSize).map(TerminableWrappedStream::toList);
    }

    default public <K, V> EntryStream<K, V> toEntries(Function<T, K> keyMapper, Function<T, V> valueMapper) {
        Objects.requireNonNull(keyMapper);
        Objects.requireNonNull(valueMapper);
        return new EntryStream(this.map((T t) -> EntryStream.ofEntry(keyMapper.apply(t), valueMapper.apply(t))));
    }

    default public <K> EntryStream<K, T> toEntries(Function<T, K> keyMapper) {
        return this.toEntries(keyMapper, Function.identity());
    }

    default public S reverse() {
        Object[] array = this.toArray();
        ArrayUtil.reverse(array);
        return ((TransformableWrappedStream)this.wrap(Stream.of(array))).parallel(this.isParallel());
    }

    default public S parallel(boolean parallel) {
        return (S)(parallel ? (TransformableWrappedStream)this.parallel() : (TransformableWrappedStream)this.sequential());
    }

    default public S splice(int start, int deleteCount, T ... items) {
        List elements = this.unwrap().collect(Collectors.toList());
        return ((TransformableWrappedStream)this.wrap(ListUtil.splice(elements, start, deleteCount, items).stream())).parallel(this.isParallel());
    }

    default public S takeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return (S)((TransformableWrappedStream)this.wrap(StreamUtil.takeWhile(this.unwrap(), predicate)));
    }

    default public S dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        return (S)((TransformableWrappedStream)this.wrap(StreamUtil.dropWhile(this.unwrap(), predicate)));
    }

    default public <F> EasyStream<T> distinct(Function<? super T, F> keyExtractor) {
        Objects.requireNonNull(keyExtractor);
        if (this.isParallel()) {
            SafeConcurrentHashMap exists = new SafeConcurrentHashMap();
            AtomicBoolean hasNull = new AtomicBoolean(false);
            return (EasyStream)EasyStream.of(this.unwrap().filter((? super T e) -> {
                Object key = keyExtractor.apply(e);
                if (key == null) {
                    if (hasNull.get()) {
                        return false;
                    }
                    hasNull.set(Boolean.TRUE);
                    return true;
                }
                return null == exists.putIfAbsent(key, Boolean.TRUE);
            })).parallel();
        }
        HashSet exists = new HashSet();
        return EasyStream.of(this.unwrap().filter((? super T e) -> exists.add(keyExtractor.apply(e))));
    }

    default public S peekIdx(BiConsumer<? super T, Integer> action) {
        Objects.requireNonNull(action);
        AtomicInteger index = new AtomicInteger(-1);
        return (S)((TransformableWrappedStream)this.peek((T e) -> action.accept(e, index.incrementAndGet())));
    }

    default public S log() {
        return (S)((TransformableWrappedStream)this.peek(Console::log));
    }

    default public S push(T ... obj) {
        Stream result = this.unwrap();
        if (ArrayUtil.isNotEmpty(obj)) {
            result = Stream.concat(this.unwrap(), Stream.of(obj));
        }
        return (S)((TransformableWrappedStream)this.wrap(result));
    }

    default public S unshift(T ... obj) {
        Stream result = this.unwrap();
        if (ArrayUtil.isNotEmpty(obj)) {
            result = Stream.concat(Stream.of(obj), this.unwrap());
        }
        return (S)((TransformableWrappedStream)this.wrap(result));
    }

    default public S append(Iterable<? extends T> iterable) {
        if (IterUtil.isEmpty(iterable)) {
            return (S)((TransformableWrappedStream)this.wrap(this));
        }
        Stream<? extends T> contacted = StreamSupport.stream(iterable.spliterator(), this.isParallel());
        return (S)((TransformableWrappedStream)this.wrap(Stream.concat(this, contacted)));
    }

    default public S prepend(Iterable<? extends T> iterable) {
        if (IterUtil.isEmpty(iterable)) {
            return (S)((TransformableWrappedStream)this.wrap(this));
        }
        Stream<? extends T> contacted = StreamSupport.stream(iterable.spliterator(), this.isParallel());
        return (S)((TransformableWrappedStream)this.wrap(Stream.concat(contacted, this)));
    }

    default public S nonNull() {
        return (S)((TransformableWrappedStream)this.filter(Objects::nonNull));
    }

    default public S filterIdx(BiPredicate<? super T, Integer> predicate) {
        Objects.requireNonNull(predicate);
        MutableInt index = new MutableInt(-1);
        return (S)((TransformableWrappedStream)this.filter((T e) -> predicate.test(e, index.incrementAndGet())));
    }

    default public <R> S filter(Function<? super T, ? extends R> mapper, R value) {
        Objects.requireNonNull(mapper);
        return (S)((TransformableWrappedStream)this.filter((T e) -> Objects.equals(mapper.apply(e), value)));
    }

    @Override
    default public <R> EasyStream<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        return new EasyStream(this.unwrap().flatMap(mapper));
    }

    default public <R> EasyStream<R> flatMapIdx(BiFunction<? super T, Integer, ? extends Stream<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        MutableInt index = new MutableInt(-1);
        return this.flatMap((T e) -> (Stream)mapper.apply(e, index.incrementAndGet()));
    }

    default public <R> EasyStream<R> flat(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        return this.flatMap((T w) -> EasyStream.of((Iterable)mapper.apply(w)));
    }

    default public <R> EasyStream<R> flatNonNull(Function<? super T, ? extends Iterable<? extends R>> mapper) {
        return (EasyStream)this.nonNull().flat(mapper).nonNull();
    }

    default public S flatTree(Function<T, List<T>> childrenGetter, BiConsumer<T, List<T>> childrenSetter) {
        Objects.requireNonNull(childrenGetter);
        Objects.requireNonNull(childrenSetter);
        MutableObj<Function<Object, EasyStream>> recursiveRef = new MutableObj<Function<Object, EasyStream>>();
        Function<Object, EasyStream> recursive = e -> (EasyStream)EasyStream.of((Iterable)childrenGetter.apply(e)).flat((Function)recursiveRef.get()).unshift(e);
        recursiveRef.set(recursive);
        return (S)((TransformableWrappedStream)this.wrap(this.flatMap(recursive).peek((T e) -> childrenSetter.accept(e, null))));
    }

    @Override
    default public <R> EasyStream<R> map(Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        return new EasyStream<R>(this.unwrap().map(mapper));
    }

    default public <R> EasyStream<R> mapNonNull(Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        return new EasyStream(this.nonNull().map((Function)mapper).nonNull());
    }

    default public <R> EasyStream<R> mapIdx(BiFunction<? super T, Integer, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        MutableInt index = new MutableInt(-1);
        return this.map((T e) -> mapper.apply(e, index.incrementAndGet()));
    }

    @Override
    default public <R> EasyStream<R> mapMulti(BiConsumer<? super T, ? super Consumer<R>> mapper) {
        Objects.requireNonNull(mapper);
        return this.flatMap((T e) -> {
            EasyStream.Builder buffer = EasyStream.builder();
            mapper.accept(e, buffer);
            return (Stream)buffer.build();
        });
    }
}

