/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.jndi;

import javax.sql.DataSource;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.ds.AbstractDSFactory;
import org.dromara.hutool.db.ds.DSUtil;
import org.dromara.hutool.setting.Setting;

public class JndiDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = 1573625812927370432L;
    public static final String DS_NAME = "JNDI DataSource";

    public JndiDSFactory() {
        this(null);
    }

    public JndiDSFactory(Setting setting) {
        super(DS_NAME, null, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, Setting poolSetting) {
        String jndiName = poolSetting.getStr("jndi");
        if (StrUtil.isEmpty(jndiName)) {
            throw new DbRuntimeException("No setting name [jndi] for this group.");
        }
        return DSUtil.getJndiDS(jndiName);
    }
}

