/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.pooled;

import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.dialect.DriverUtil;
import org.dromara.hutool.db.ds.DSKeys;
import org.dromara.hutool.db.ds.pooled.DbConfig;
import org.dromara.hutool.setting.Setting;

public class DbSetting {
    public static final String DEFAULT_DB_CONFIG_PATH = "config/db.setting";
    private final Setting setting;

    public DbSetting() {
        this(null);
    }

    public DbSetting(Setting setting) {
        this.setting = null == setting ? new Setting(DEFAULT_DB_CONFIG_PATH) : setting;
    }

    public DbConfig getDbConfig(String group) {
        Setting config = this.setting.getSetting(group);
        if (MapUtil.isEmpty(config)) {
            throw new DbRuntimeException("No Hutool pool config for group: [{}]", group);
        }
        DbConfig dbConfig = new DbConfig();
        String url = config.getAndRemove(DSKeys.KEY_ALIAS_URL);
        if (StrUtil.isBlank(url)) {
            throw new DbRuntimeException("No JDBC URL for group: [{}]", group);
        }
        dbConfig.setUrl(url);
        String driver = config.getAndRemove(DSKeys.KEY_ALIAS_DRIVER);
        dbConfig.setDriver(StrUtil.isNotBlank(driver) ? driver : DriverUtil.identifyDriver(url));
        dbConfig.setUser(config.getAndRemove(DSKeys.KEY_ALIAS_USER));
        dbConfig.setPass(config.getAndRemove(DSKeys.KEY_ALIAS_PASSWORD));
        dbConfig.setInitialSize(this.setting.getIntByGroup("initialSize", group, 0));
        dbConfig.setMinIdle(this.setting.getIntByGroup("minIdle", group, 0));
        dbConfig.setMaxActive(this.setting.getIntByGroup("maxActive", group, 8));
        dbConfig.setMaxWait(this.setting.getLongByGroup("maxWait", group, 6000L));
        for (String key : DSKeys.KEY_CONN_PROPS) {
            String connValue = config.get(key);
            if (!StrUtil.isNotBlank(connValue)) continue;
            dbConfig.addConnProps(key, connValue);
        }
        return dbConfig;
    }
}

