/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.compress.extractor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.RandomAccess;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.extra.compress.extractor.Extractor;
import org.dromara.hutool.extra.compress.extractor.Seven7EntryInputStream;

public class SevenZExtractor
implements Extractor,
RandomAccess {
    private final SevenZFile sevenZFile;

    public SevenZExtractor(File file) {
        this(file, null);
    }

    public SevenZExtractor(File file, char[] password) {
        try {
            this.sevenZFile = new SevenZFile(file, password);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public SevenZExtractor(InputStream in) {
        this(in, null);
    }

    public SevenZExtractor(InputStream in, char[] password) {
        this((SeekableByteChannel)new SeekableInMemoryByteChannel(IoUtil.readBytes(in)), password);
    }

    public SevenZExtractor(SeekableByteChannel channel) {
        this(channel, null);
    }

    public SevenZExtractor(SeekableByteChannel channel, char[] password) {
        try {
            this.sevenZFile = new SevenZFile(channel, password);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    @Override
    public void extract(File targetDir, Predicate<ArchiveEntry> predicate) {
        try {
            this.extractInternal(targetDir, predicate);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            this.close();
        }
    }

    @Override
    public InputStream getFirst(Predicate<ArchiveEntry> predicate) {
        SevenZFile sevenZFile = this.sevenZFile;
        for (SevenZArchiveEntry entry : sevenZFile.getEntries()) {
            if (null != predicate && !predicate.test((ArchiveEntry)entry) || entry.isDirectory()) continue;
            try {
                return sevenZFile.getInputStream(entry);
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
        }
        return null;
    }

    private void extractInternal(File targetDir, Predicate<ArchiveEntry> predicate) throws IOException {
        SevenZArchiveEntry entry;
        Assert.isTrue(null != targetDir && (!targetDir.exists() || targetDir.isDirectory()), "target must be dir.", new Object[0]);
        SevenZFile sevenZFile = this.sevenZFile;
        while (null != (entry = sevenZFile.getNextEntry())) {
            if (null != predicate && !predicate.test((ArchiveEntry)entry)) continue;
            File outItemFile = FileUtil.file(targetDir, entry.getName());
            if (entry.isDirectory()) {
                outItemFile.mkdirs();
                continue;
            }
            if (entry.hasStream()) {
                FileUtil.writeFromStream((InputStream)new Seven7EntryInputStream(sevenZFile, entry), outItemFile);
                continue;
            }
            FileUtil.touch(outItemFile);
        }
    }

    @Override
    public void close() {
        IoUtil.closeQuietly(new AutoCloseable[]{this.sevenZFile});
    }
}

