/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.map.multi.ListValueMap;
import org.dromara.hutool.core.net.url.UrlBuilder;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.http.GlobalHeaders;
import org.dromara.hutool.http.HttpGlobalConfig;
import org.dromara.hutool.http.HttpUtil;
import org.dromara.hutool.http.client.HeaderOperation;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.client.body.HttpBody;
import org.dromara.hutool.http.client.body.StringBody;
import org.dromara.hutool.http.client.body.UrlEncodedFormBody;
import org.dromara.hutool.http.meta.HeaderName;
import org.dromara.hutool.http.meta.Method;

public class Request
implements HeaderOperation<Request> {
    private static final Charset DEFAULT_CHARSET = CharsetUtil.UTF_8;
    private Method method = Method.GET;
    private UrlBuilder url;
    private final ListValueMap<String, String> headers = new ListValueMap(new LinkedHashMap());
    private HttpBody body;
    private int maxRedirectCount = HttpGlobalConfig.getMaxRedirectCount();

    public static Request of(String url) {
        return Request.of(url, HttpGlobalConfig.isDecodeUrl() ? DEFAULT_CHARSET : null);
    }

    public static Request of(String url, Charset charset) {
        return Request.of(UrlBuilder.ofHttp(url, charset));
    }

    public static Request of(UrlBuilder url) {
        return new Request().url(url);
    }

    public Request() {
        this.header(GlobalHeaders.INSTANCE.headers(), false);
    }

    public Method method() {
        return this.method;
    }

    public Request method(Method method) {
        this.method = method;
        return this;
    }

    public UrlBuilder url() {
        return this.url;
    }

    public Request url(UrlBuilder url) {
        this.url = url;
        return this;
    }

    public Request charset(Charset charset) {
        Assert.notNull(this.url, "You must be set request url first.", new Object[0]);
        this.url.setCharset(charset);
        return this;
    }

    public Charset charset() {
        Assert.notNull(this.url, "You must be set request url first.", new Object[0]);
        return ObjUtil.defaultIfNull(this.url.getCharset(), DEFAULT_CHARSET);
    }

    @Override
    public Map<String, ? extends Collection<String>> headers() {
        return MapUtil.view(this.headers);
    }

    public boolean isChunked() {
        String transferEncoding = this.header(HeaderName.TRANSFER_ENCODING);
        return "Chunked".equalsIgnoreCase(transferEncoding);
    }

    @Override
    public Request header(String name, String value, boolean isOverride) {
        if (null == name) {
            return this;
        }
        if (null == value) {
            this.headers.remove(name);
            return this;
        }
        if (isOverride) {
            this.headers.put(name.trim(), (String)((Object)ListUtil.of(value)));
        } else {
            this.headers.putValue(name.trim(), value);
        }
        return this;
    }

    public HttpBody body() {
        return this.body;
    }

    public Request form(Map<String, Object> formMap) {
        return this.body(new UrlEncodedFormBody(formMap, this.charset()));
    }

    public Request body(String body) {
        return this.body(new StringBody(body, this.charset()));
    }

    public Request body(HttpBody body) {
        this.body = body;
        if (StrUtil.isBlank(this.header(HeaderName.CONTENT_TYPE))) {
            this.header(HeaderName.CONTENT_TYPE, body.getContentType(this.charset()), true);
        }
        return this;
    }

    public int maxRedirectCount() {
        return this.maxRedirectCount;
    }

    public Request setMaxRedirectCount(int maxRedirectCount) {
        this.maxRedirectCount = Math.max(maxRedirectCount, 0);
        return this;
    }

    public Response send() {
        return HttpUtil.send(this);
    }
}

