/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.webservice;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.xml.XmlUtil;
import org.dromara.hutool.http.webservice.SoapClient;
import org.dromara.hutool.http.webservice.SoapProtocol;
import org.dromara.hutool.http.webservice.SoapRuntimeException;

public class SoapUtil {
    public static SoapClient createClient(String url) {
        return SoapClient.of(url);
    }

    public static SoapClient createClient(String url, SoapProtocol protocol) {
        return SoapClient.of(url, protocol);
    }

    public static SoapClient createClient(String url, SoapProtocol protocol, String namespaceURI) {
        return SoapClient.of(url, protocol, namespaceURI);
    }

    public static String toString(SOAPMessage message, boolean pretty) {
        return SoapUtil.toString(message, pretty, CharsetUtil.UTF_8);
    }

    public static String toString(SOAPMessage message, boolean pretty, Charset charset) {
        String messageToString;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            message.writeTo((OutputStream)out);
        }
        catch (IOException | SOAPException e) {
            throw new SoapRuntimeException(e);
        }
        try {
            messageToString = out.toString(charset.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new HutoolException(e);
        }
        return pretty ? XmlUtil.format(messageToString) : messageToString;
    }
}

