/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.math.NumberUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;

public class BeanPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char[] EXP_CHARS = new char[]{'.', '[', ']'};
    private boolean isStartWith = false;
    protected List<String> patternParts;

    public static BeanPath of(String expression) {
        return new BeanPath(expression);
    }

    public BeanPath(String expression) {
        this.init(expression);
    }

    public List<String> getPatternParts() {
        return this.patternParts;
    }

    public Object get(Object bean) {
        return this.get(this.patternParts, bean);
    }

    public void set(Object bean, Object value) {
        Objects.requireNonNull(bean);
        Object subBean = bean;
        Cloneable previousBean = null;
        boolean isFirst = true;
        int length = this.patternParts.size() - 1;
        for (int i = 0; i < length; ++i) {
            String patternPart = this.patternParts.get(i);
            previousBean = subBean;
            if (null != (subBean = BeanPath.getFieldValue(subBean, patternPart))) continue;
            if (isFirst && !this.isStartWith && BeanUtil.isMatchName(bean, patternPart, true)) {
                subBean = bean;
                isFirst = false;
                continue;
            }
            subBean = NumberUtil.isInteger(this.patternParts.get(i + 1)) ? new ArrayList() : new HashMap();
            BeanUtil.setFieldValue(previousBean, patternPart, subBean);
            subBean = BeanUtil.getFieldValue(previousBean, patternPart);
        }
        Object newSubBean = BeanUtil.setFieldValue(subBean, this.patternParts.get(length), value);
        if (newSubBean != subBean && null != previousBean) {
            BeanUtil.setFieldValue(previousBean, this.patternParts.get(length - 1), newSubBean);
        }
    }

    public String toString() {
        return this.patternParts.toString();
    }

    private Object get(List<String> patternParts, Object bean) {
        Object subBean = bean;
        boolean isFirst = true;
        for (String patternPart : patternParts) {
            if (null != (subBean = BeanPath.getFieldValue(subBean, patternPart))) continue;
            if (isFirst && !this.isStartWith && BeanUtil.isMatchName(bean, patternPart, true)) {
                subBean = bean;
                isFirst = false;
                continue;
            }
            return null;
        }
        return subBean;
    }

    private static Object getFieldValue(Object bean, String expression) {
        if (StrUtil.isBlank(expression)) {
            return null;
        }
        if (StrUtil.contains((CharSequence)expression, ':')) {
            List<String> parts = SplitUtil.splitTrim(expression, ":");
            int start = Integer.parseInt(parts.get(0));
            int end = Integer.parseInt(parts.get(1));
            int step = 1;
            if (3 == parts.size()) {
                step = Integer.parseInt(parts.get(2));
            }
            if (bean instanceof Collection) {
                return CollUtil.sub((Collection)bean, start, end, step);
            }
            if (ArrayUtil.isArray(bean)) {
                return ArrayUtil.sub(bean, start, end, step);
            }
        } else {
            if (StrUtil.contains((CharSequence)expression, ',')) {
                List<String> keys = SplitUtil.splitTrim(expression, ",");
                if (bean instanceof Collection) {
                    return CollUtil.getAny((Collection)bean, Convert.convert(int[].class, keys));
                }
                if (ArrayUtil.isArray(bean)) {
                    return ArrayUtil.getAny(bean, Convert.convert(int[].class, keys));
                }
                String[] unWrappedKeys = new String[keys.size()];
                for (int i = 0; i < unWrappedKeys.length; ++i) {
                    unWrappedKeys[i] = StrUtil.unWrap(keys.get(i), '\'');
                }
                if (bean instanceof Map) {
                    return MapUtil.getAny((Map)bean, unWrappedKeys);
                }
                Map<String, Object> map = BeanUtil.beanToMap(bean, new String[0]);
                return MapUtil.getAny(map, unWrappedKeys);
            }
            return BeanUtil.getFieldValue(bean, expression);
        }
        return null;
    }

    private void init(String expression) {
        ArrayList<String> localPatternParts = new ArrayList<String>();
        int length = expression.length();
        StringBuilder builder = new StringBuilder();
        boolean isNumStart = false;
        boolean isInWrap = false;
        for (int i = 0; i < length; ++i) {
            char c = expression.charAt(i);
            if (0 == i && '$' == c) {
                this.isStartWith = true;
                continue;
            }
            if ('\'' == c) {
                isInWrap = !isInWrap;
                continue;
            }
            if (!isInWrap && ArrayUtil.contains(EXP_CHARS, c)) {
                if (']' == c) {
                    if (!isNumStart) {
                        throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find ']' but no '[' !", expression, i));
                    }
                    isNumStart = false;
                } else {
                    if (isNumStart) {
                        throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find '[' but no ']' !", expression, i));
                    }
                    if ('[' == c) {
                        isNumStart = true;
                    }
                }
                if (builder.length() > 0) {
                    localPatternParts.add(builder.toString());
                }
                builder.setLength(0);
                continue;
            }
            builder.append(c);
        }
        if (isNumStart) {
            throw new IllegalArgumentException(StrUtil.format("Bad expression '{}':{}, we find '[' but no ']' !", expression, length - 1));
        }
        if (builder.length() > 0) {
            localPatternParts.add(builder.toString());
        }
        this.patternParts = ListUtil.view(localPatternParts);
    }
}

