/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.comparator;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.regex.PatternPool;
import org.dromara.hutool.core.regex.ReUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.core.util.ObjUtil;

public class VersionComparator
implements Comparator<String>,
Serializable {
    private static final long serialVersionUID = 8083701245147495562L;
    public static final VersionComparator INSTANCE = new VersionComparator();

    @Override
    public int compare(String version1, String version2) {
        if (ObjUtil.equals(version1, version2)) {
            return 0;
        }
        if (version1 == null && version2 == null) {
            return 0;
        }
        if (version1 == null) {
            return -1;
        }
        if (version2 == null) {
            return 1;
        }
        List<String> v1s = SplitUtil.splitTrim(version1, ".");
        List<String> v2s = SplitUtil.splitTrim(version2, ".");
        int diff = 0;
        int minLength = Math.min(v1s.size(), v2s.size());
        for (int i = 0; i < minLength; ++i) {
            String v1 = v1s.get(i);
            String v2 = v2s.get(i);
            diff = v1.length() - v2.length();
            if (0 == diff) {
                diff = v1.compareTo(v2);
            } else {
                int v2Num;
                int v1Num = Convert.toInt(ReUtil.get(PatternPool.NUMBERS, (CharSequence)v1, 0), 0);
                int diff1 = v1Num - (v2Num = Convert.toInt(ReUtil.get(PatternPool.NUMBERS, (CharSequence)v2, 0), 0).intValue());
                if (diff1 != 0) {
                    diff = diff1;
                }
            }
            if (diff != 0) break;
        }
        return diff != 0 ? diff : v1s.size() - v2s.size();
    }
}

