/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.compress;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.compress.ZipUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.resource.Resource;
import org.dromara.hutool.core.text.StrUtil;

public class ZipWriter
implements Closeable {
    private final ZipOutputStream out;
    private int bufferSize = 8192;

    public static ZipWriter of(File zipFile, Charset charset) {
        return new ZipWriter(zipFile, charset);
    }

    public static ZipWriter of(OutputStream out, Charset charset) {
        return new ZipWriter(out, charset);
    }

    public ZipWriter(File zipFile, Charset charset) {
        this(ZipWriter.getZipOutputStream(zipFile, charset));
    }

    public ZipWriter(OutputStream out, Charset charset) {
        this(ZipUtil.getZipOutputStream(out, charset));
    }

    public ZipWriter(ZipOutputStream out) {
        this.out = out;
    }

    public ZipWriter setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public ZipWriter setLevel(int level) {
        this.out.setLevel(level);
        return this;
    }

    public ZipWriter setComment(String comment) {
        this.out.setComment(comment);
        return this;
    }

    public ZipWriter setMethod(int method) {
        this.out.setMethod(method);
        return this;
    }

    public ZipOutputStream getOut() {
        return this.out;
    }

    public ZipWriter add(boolean withSrcDir, FileFilter filter, File ... files) throws IORuntimeException {
        for (File file : files) {
            String srcRootDir;
            try {
                srcRootDir = file.getCanonicalPath();
                if (!file.isDirectory() || withSrcDir) {
                    srcRootDir = file.getCanonicalFile().getParentFile().getCanonicalPath();
                }
            }
            catch (IOException e) {
                throw new IORuntimeException(e);
            }
            this._add(file, srcRootDir, filter);
        }
        return this;
    }

    public ZipWriter add(Resource ... resources) throws IORuntimeException {
        for (Resource resource : resources) {
            if (null == resource) continue;
            this.add(resource.getName(), resource.getStream());
        }
        return this;
    }

    public ZipWriter add(String path, InputStream in) throws IORuntimeException {
        path = StrUtil.emptyIfNull(path);
        if (null == in && StrUtil.isBlank(path = StrUtil.addSuffixIfNot(path, "/"))) {
            return this;
        }
        return this.putEntry(path, in);
    }

    public ZipWriter add(String[] paths, InputStream[] ins) throws IORuntimeException {
        if (ArrayUtil.isEmpty(paths) || ArrayUtil.isEmpty(ins)) {
            throw new IllegalArgumentException("Paths or ins is empty !");
        }
        if (paths.length != ins.length) {
            throw new IllegalArgumentException("Paths length is not equals to ins length !");
        }
        for (int i = 0; i < paths.length; ++i) {
            this.add(paths[i], ins[i]);
        }
        return this;
    }

    @Override
    public void close() throws IORuntimeException {
        try {
            this.out.finish();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(this.out);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(this.out);
    }

    private static ZipOutputStream getZipOutputStream(File zipFile, Charset charset) {
        return ZipUtil.getZipOutputStream(FileUtil.getOutputStream(zipFile), charset);
    }

    private void _add(File file, String srcRootDir, FileFilter filter) throws IORuntimeException {
        if (null == file || null != filter && !filter.accept(file)) {
            return;
        }
        String subPath = FileUtil.subPath(srcRootDir, file);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (ArrayUtil.isEmpty(files)) {
                this.add(subPath, null);
            } else {
                for (File childFile : files) {
                    this._add(childFile, srcRootDir, filter);
                }
            }
        } else {
            this.putEntry(subPath, FileUtil.getInputStream(file));
        }
    }

    private ZipWriter putEntry(String path, InputStream in) throws IORuntimeException {
        ZipEntry entry = new ZipEntry(path);
        ZipOutputStream out = this.out;
        try {
            out.putNextEntry(entry);
            if (null != in) {
                IoUtil.copy(in, out, this.bufferSize);
            }
            out.closeEntry();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(in);
        IoUtil.flush(out);
        return this;
    }
}

