/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.convert;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.datatype.XMLGregorianCalendar;
import org.dromara.hutool.core.convert.CompositeConverter;
import org.dromara.hutool.core.convert.ConvertException;
import org.dromara.hutool.core.convert.Converter;
import org.dromara.hutool.core.convert.impl.AtomicBooleanConverter;
import org.dromara.hutool.core.convert.impl.AtomicIntegerArrayConverter;
import org.dromara.hutool.core.convert.impl.AtomicLongArrayConverter;
import org.dromara.hutool.core.convert.impl.AtomicReferenceConverter;
import org.dromara.hutool.core.convert.impl.BooleanConverter;
import org.dromara.hutool.core.convert.impl.CalendarConverter;
import org.dromara.hutool.core.convert.impl.CharacterConverter;
import org.dromara.hutool.core.convert.impl.CharsetConverter;
import org.dromara.hutool.core.convert.impl.CurrencyConverter;
import org.dromara.hutool.core.convert.impl.DateConverter;
import org.dromara.hutool.core.convert.impl.DurationConverter;
import org.dromara.hutool.core.convert.impl.LocaleConverter;
import org.dromara.hutool.core.convert.impl.OptConverter;
import org.dromara.hutool.core.convert.impl.OptionalConverter;
import org.dromara.hutool.core.convert.impl.PairConverter;
import org.dromara.hutool.core.convert.impl.PathConverter;
import org.dromara.hutool.core.convert.impl.PeriodConverter;
import org.dromara.hutool.core.convert.impl.ReferenceConverter;
import org.dromara.hutool.core.convert.impl.StackTraceElementConverter;
import org.dromara.hutool.core.convert.impl.StringConverter;
import org.dromara.hutool.core.convert.impl.TemporalAccessorConverter;
import org.dromara.hutool.core.convert.impl.TimeZoneConverter;
import org.dromara.hutool.core.convert.impl.TripleConverter;
import org.dromara.hutool.core.convert.impl.TupleConverter;
import org.dromara.hutool.core.convert.impl.URIConverter;
import org.dromara.hutool.core.convert.impl.URLConverter;
import org.dromara.hutool.core.convert.impl.UUIDConverter;
import org.dromara.hutool.core.convert.impl.XMLGregorianCalendarConverter;
import org.dromara.hutool.core.convert.impl.ZoneIdConverter;
import org.dromara.hutool.core.date.DateTime;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.lang.tuple.Pair;
import org.dromara.hutool.core.lang.tuple.Triple;
import org.dromara.hutool.core.lang.tuple.Tuple;
import org.dromara.hutool.core.map.SafeConcurrentHashMap;
import org.dromara.hutool.core.reflect.TypeUtil;

public class RegisterConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Class<?>, Converter> defaultConverterMap;
    private volatile Map<Type, Converter> customConverterMap;

    public static CompositeConverter getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public RegisterConverter() {
        this.registerDefault();
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        Converter converter = this.getConverter(targetType, true);
        if (null != converter) {
            return converter.convert(targetType, value);
        }
        throw new ConvertException("Can not convert from {}: [{}] to [{}]", value.getClass().getName(), value, targetType.getTypeName());
    }

    public Converter getConverter(Type type, boolean isCustomFirst) {
        Converter converter;
        if (isCustomFirst) {
            converter = this.getCustomConverter(type);
            if (null == converter) {
                converter = this.getDefaultConverter(type);
            }
        } else {
            converter = this.getDefaultConverter(type);
            if (null == converter) {
                converter = this.getCustomConverter(type);
            }
        }
        return converter;
    }

    public Converter getDefaultConverter(Type type) {
        return null == this.defaultConverterMap ? null : this.defaultConverterMap.get(TypeUtil.getClass(type));
    }

    public Converter getCustomConverter(Type type) {
        return null == this.customConverterMap ? null : this.customConverterMap.get(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisterConverter putCustom(Type type, Converter converter) {
        if (null == this.customConverterMap) {
            RegisterConverter registerConverter = this;
            synchronized (registerConverter) {
                if (null == this.customConverterMap) {
                    this.customConverterMap = new SafeConcurrentHashMap<Type, Converter>();
                }
            }
        }
        this.customConverterMap.put(type, converter);
        return this;
    }

    private void registerDefault() {
        this.defaultConverterMap = new SafeConcurrentHashMap(64);
        this.defaultConverterMap.put(Character.class, new CharacterConverter());
        this.defaultConverterMap.put(Boolean.class, new BooleanConverter());
        this.defaultConverterMap.put(AtomicBoolean.class, new AtomicBooleanConverter());
        this.defaultConverterMap.put(CharSequence.class, new StringConverter());
        this.defaultConverterMap.put(String.class, new StringConverter());
        this.defaultConverterMap.put(URI.class, new URIConverter());
        this.defaultConverterMap.put(URL.class, new URLConverter());
        this.defaultConverterMap.put(Calendar.class, new CalendarConverter());
        this.defaultConverterMap.put(XMLGregorianCalendar.class, new XMLGregorianCalendarConverter());
        this.defaultConverterMap.put(java.util.Date.class, DateConverter.INSTANCE);
        this.defaultConverterMap.put(DateTime.class, DateConverter.INSTANCE);
        this.defaultConverterMap.put(Date.class, DateConverter.INSTANCE);
        this.defaultConverterMap.put(Time.class, DateConverter.INSTANCE);
        this.defaultConverterMap.put(Timestamp.class, DateConverter.INSTANCE);
        this.defaultConverterMap.put(TemporalAccessor.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(Instant.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(LocalDateTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(LocalDate.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(LocalTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(ZonedDateTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(OffsetDateTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(OffsetTime.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(DayOfWeek.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(Month.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(MonthDay.class, TemporalAccessorConverter.INSTANCE);
        this.defaultConverterMap.put(Period.class, new PeriodConverter());
        this.defaultConverterMap.put(Duration.class, new DurationConverter());
        this.defaultConverterMap.put(WeakReference.class, ReferenceConverter.INSTANCE);
        this.defaultConverterMap.put(SoftReference.class, ReferenceConverter.INSTANCE);
        this.defaultConverterMap.put(AtomicReference.class, new AtomicReferenceConverter());
        this.defaultConverterMap.put(AtomicIntegerArray.class, new AtomicIntegerArrayConverter());
        this.defaultConverterMap.put(AtomicLongArray.class, new AtomicLongArrayConverter());
        this.defaultConverterMap.put(TimeZone.class, new TimeZoneConverter());
        this.defaultConverterMap.put(ZoneId.class, new ZoneIdConverter());
        this.defaultConverterMap.put(Locale.class, new LocaleConverter());
        this.defaultConverterMap.put(Charset.class, new CharsetConverter());
        this.defaultConverterMap.put(Path.class, new PathConverter());
        this.defaultConverterMap.put(Currency.class, new CurrencyConverter());
        this.defaultConverterMap.put(UUID.class, new UUIDConverter());
        this.defaultConverterMap.put(StackTraceElement.class, new StackTraceElementConverter());
        this.defaultConverterMap.put(Optional.class, new OptionalConverter());
        this.defaultConverterMap.put(Opt.class, new OptConverter());
        this.defaultConverterMap.put(Pair.class, PairConverter.INSTANCE);
        this.defaultConverterMap.put(Triple.class, TripleConverter.INSTANCE);
        this.defaultConverterMap.put(Tuple.class, TupleConverter.INSTANCE);
    }

    private static class SingletonHolder {
        private static final CompositeConverter INSTANCE = new CompositeConverter();

        private SingletonHolder() {
        }
    }
}

