/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.dromara.hutool.core.codec.HexUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileMagicNumber;
import org.dromara.hutool.core.io.file.FileNameUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.text.StrUtil;

public class FileTypeUtil {
    private static final Map<String, String> FILE_TYPE_MAP = new ConcurrentSkipListMap<String, String>();

    public static String putFileType(String fileStreamHexHead, String extName) {
        return FILE_TYPE_MAP.put(fileStreamHexHead, extName);
    }

    public static String removeFileType(String fileStreamHexHead) {
        return FILE_TYPE_MAP.remove(fileStreamHexHead);
    }

    public static String getType(String fileStreamHexHead) {
        for (Map.Entry<String, String> fileTypeEntry : FILE_TYPE_MAP.entrySet()) {
            if (!StrUtil.startWithIgnoreCase(fileStreamHexHead, fileTypeEntry.getKey())) continue;
            return fileTypeEntry.getValue();
        }
        byte[] bytes = HexUtil.decodeHex(fileStreamHexHead);
        return FileMagicNumber.getMagicNumber(bytes).getExtension();
    }

    public static String getType(InputStream in, int fileHeadSize) throws IORuntimeException {
        return FileTypeUtil.getType(IoUtil.readHex(in, fileHeadSize, false));
    }

    public static String getType(InputStream in, boolean isExact) throws IORuntimeException {
        return isExact ? FileTypeUtil.getType(FileTypeUtil.readHex8192Upper(in)) : FileTypeUtil.getType(FileTypeUtil.readHex64Upper(in));
    }

    public static String getType(InputStream in) throws IORuntimeException {
        return FileTypeUtil.getType(in, false);
    }

    public static String getType(InputStream in, String filename) throws IORuntimeException {
        return FileTypeUtil.getType(in, filename, false);
    }

    public static String getType(InputStream in, String filename, boolean isExact) throws IORuntimeException {
        String typeName = FileTypeUtil.getType(in, isExact);
        if (null == typeName) {
            typeName = FileNameUtil.extName(filename);
        } else if ("zip".equals(typeName)) {
            String extName = FileNameUtil.extName(filename);
            if ("docx".equalsIgnoreCase(extName)) {
                typeName = "docx";
            } else if ("xlsx".equalsIgnoreCase(extName)) {
                typeName = "xlsx";
            } else if ("pptx".equalsIgnoreCase(extName)) {
                typeName = "pptx";
            } else if ("jar".equalsIgnoreCase(extName)) {
                typeName = "jar";
            } else if ("war".equalsIgnoreCase(extName)) {
                typeName = "war";
            } else if ("ofd".equalsIgnoreCase(extName)) {
                typeName = "ofd";
            } else if ("apk".equalsIgnoreCase(extName)) {
                typeName = "apk";
            }
        } else if ("jar".equals(typeName)) {
            String extName = FileNameUtil.extName(filename);
            if ("xlsx".equalsIgnoreCase(extName)) {
                typeName = "xlsx";
            } else if ("docx".equalsIgnoreCase(extName)) {
                typeName = "docx";
            } else if ("pptx".equalsIgnoreCase(extName)) {
                typeName = "pptx";
            } else if ("zip".equalsIgnoreCase(extName)) {
                typeName = "zip";
            } else if ("apk".equalsIgnoreCase(extName)) {
                typeName = "apk";
            }
        }
        return typeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getType(File file, boolean isExact) throws IORuntimeException {
        String string;
        if (!FileUtil.isFile(file)) {
            throw new IllegalArgumentException("Not a regular file!");
        }
        InputStream in = null;
        try {
            in = IoUtil.toStream(file);
            string = FileTypeUtil.getType(in, file.getName(), isExact);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly(in);
            throw throwable;
        }
        IoUtil.closeQuietly(in);
        return string;
    }

    public static String getType(File file) throws IORuntimeException {
        return FileTypeUtil.getType(file, false);
    }

    public static String getTypeByPath(String path, boolean isExact) throws IORuntimeException {
        return FileTypeUtil.getType(FileUtil.file(path), isExact);
    }

    public static String getTypeByPath(String path) throws IORuntimeException {
        return FileTypeUtil.getTypeByPath(path, false);
    }

    private static String readHex8192Upper(InputStream in) throws IORuntimeException {
        try {
            return IoUtil.readHex(in, Math.min(8192, in.available()), false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String readHex64Upper(InputStream in) throws IORuntimeException {
        return IoUtil.readHex(in, 64, false);
    }
}

