/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.net.url;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.jar.JarFile;
import org.dromara.hutool.core.classloader.ClassLoaderUtil;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.resource.ResourceUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.net.url.RFC3986;
import org.dromara.hutool.core.net.url.URLEncoder;
import org.dromara.hutool.core.net.url.UrlQuery;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class URLUtil {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String WAR_URL_PREFIX = "war:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String WAR_URL_SEPARATOR = "*/";

    public static URL url(URI uri) throws HutoolException {
        if (null == uri) {
            return null;
        }
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new HutoolException(e);
        }
    }

    public static URL url(String url) {
        return URLUtil.url(url, null);
    }

    public static URL url(String url, URLStreamHandler handler) {
        if (null == url) {
            return null;
        }
        if (url.startsWith(CLASSPATH_URL_PREFIX)) {
            url = url.substring(CLASSPATH_URL_PREFIX.length());
            return ClassLoaderUtil.getClassLoader().getResource(url);
        }
        try {
            return new URL(null, url, handler);
        }
        catch (MalformedURLException e) {
            try {
                return new File(url).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new HutoolException(e);
            }
        }
    }

    public static URI getStringURI(CharSequence content) {
        if (null == content) {
            return null;
        }
        String contentStr = StrUtil.addPrefixIfNot(content, "string:///");
        return URI.create(contentStr);
    }

    public static URL toUrlForHttp(String urlStr) {
        return URLUtil.toUrlForHttp(urlStr, null);
    }

    public static URL toUrlForHttp(String urlStr, URLStreamHandler handler) {
        Assert.notBlank(urlStr, "Url is blank !", new Object[0]);
        urlStr = URLEncoder.encodeBlank(urlStr);
        try {
            return new URL(null, urlStr, handler);
        }
        catch (MalformedURLException e) {
            throw new HutoolException(e);
        }
    }

    public static URL getURL(String pathBaseClassLoader) {
        return ResourceUtil.getResourceUrl(pathBaseClassLoader);
    }

    public static URL getURL(String path, Class<?> clazz) {
        return ResourceUtil.getResourceUrl(path, clazz);
    }

    public static URL getURL(File file) {
        Assert.notNull(file, "File is null !", new Object[0]);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new HutoolException(e, "Error occured when get URL!", new Object[0]);
        }
    }

    public static URL[] getURLs(File ... files) {
        URL[] urls = new URL[files.length];
        try {
            for (int i = 0; i < files.length; ++i) {
                urls[i] = files[i].toURI().toURL();
            }
        }
        catch (MalformedURLException e) {
            throw new HutoolException(e, "Error occured when get URL!", new Object[0]);
        }
        return urls;
    }

    public static URI getHost(URL url) {
        if (null == url) {
            return null;
        }
        try {
            return new URI(url.getProtocol(), url.getHost(), null, null);
        }
        catch (URISyntaxException e) {
            throw new HutoolException(e);
        }
    }

    public static String completeUrl(String baseUrl, String relativePath) {
        if (StrUtil.isBlank(baseUrl = URLUtil.normalize(baseUrl, false))) {
            return null;
        }
        try {
            URL absoluteUrl = new URL(baseUrl);
            URL parseUrl = new URL(absoluteUrl, relativePath);
            return parseUrl.toString();
        }
        catch (MalformedURLException e) {
            throw new HutoolException(e);
        }
    }

    public static String getPath(String uriStr) {
        return URLUtil.toURI(uriStr).getPath();
    }

    public static String getDecodedPath(URL url) {
        if (null == url) {
            return null;
        }
        String path = null;
        try {
            path = URLUtil.toURI(url).getPath();
        }
        catch (HutoolException hutoolException) {
            // empty catch block
        }
        return null != path ? path : url.getPath();
    }

    public static URI toURI(URL url) throws HutoolException {
        return URLUtil.toURI(url, false);
    }

    public static URI toURI(URL url, boolean isEncode) throws HutoolException {
        if (null == url) {
            return null;
        }
        return URLUtil.toURI(url.toString(), isEncode);
    }

    public static URI toURI(String location) throws HutoolException {
        return URLUtil.toURI(location, false);
    }

    public static URI toURI(String location, boolean isEncode) throws HutoolException {
        if (isEncode) {
            location = RFC3986.PATH.encode(location, CharsetUtil.UTF_8, new char[0]);
        }
        try {
            return new URI(StrUtil.trim(location));
        }
        catch (URISyntaxException e) {
            throw new HutoolException(e);
        }
    }

    public static boolean isFileURL(URL url) {
        Assert.notNull(url, "URL must be not null", new Object[0]);
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(protocol);
    }

    public static boolean isJarURL(URL url) {
        Assert.notNull(url, "URL must be not null", new Object[0]);
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_VFSZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol);
    }

    public static boolean isJarFileURL(URL url) {
        Assert.notNull(url, "URL must be not null", new Object[0]);
        return URL_PROTOCOL_FILE.equals(url.getProtocol()) && url.getPath().toLowerCase().endsWith(".jar");
    }

    public static InputStream getStream(URL url) {
        Assert.notNull(url, "URL must be not null", new Object[0]);
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static BufferedReader getReader(URL url, Charset charset) {
        return IoUtil.toReader(URLUtil.getStream(url), charset);
    }

    public static JarFile getJarFile(URL url) {
        try {
            JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
            return urlConnection.getJarFile();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static String normalize(String url) {
        return URLUtil.normalize(url, false);
    }

    public static String normalize(String url, boolean isEncodePath) {
        return URLUtil.normalize(url, isEncodePath, false);
    }

    public static String normalize(String url, boolean isEncodePath, boolean replaceSlash) {
        String body;
        String protocol;
        if (StrUtil.isBlank(url)) {
            return url;
        }
        int sepIndex = url.indexOf("://");
        if (sepIndex > 0) {
            protocol = StrUtil.subPre(url, sepIndex + 3);
            body = StrUtil.subSuf(url, sepIndex + 3);
        } else {
            protocol = "http://";
            body = url;
        }
        int paramsSepIndex = StrUtil.indexOf(body, '?');
        String params = null;
        if (paramsSepIndex > 0) {
            params = StrUtil.subSuf(body, paramsSepIndex);
            body = StrUtil.subPre(body, paramsSepIndex);
        }
        if (StrUtil.isNotEmpty(body)) {
            body = body.replaceAll("^[\\\\/]+", "");
            body = body.replace("\\", "/");
            if (replaceSlash) {
                body = body.replaceAll("//+", "/");
            }
        }
        int pathSepIndex = StrUtil.indexOf(body, '/');
        String domain = body;
        String path = null;
        if (pathSepIndex > 0) {
            domain = StrUtil.subPre(body, pathSepIndex);
            path = StrUtil.subSuf(body, pathSepIndex);
        }
        if (isEncodePath) {
            path = RFC3986.PATH.encode(path, CharsetUtil.UTF_8, new char[0]);
        }
        return protocol + domain + StrUtil.emptyIfNull(path) + StrUtil.emptyIfNull(params);
    }

    public static String buildQuery(Map<String, ?> paramMap, Charset charset) {
        return UrlQuery.of(paramMap).build(charset);
    }

    public static long getContentLength(URL url) throws IORuntimeException {
        if (null == url) {
            return -1L;
        }
        URLConnection conn = null;
        try {
            conn = url.openConnection();
            long l = conn.getContentLengthLong();
            return l;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
        }
    }

    public static String getDataUriBase64(String mimeType, String data) {
        return URLUtil.getDataUri(mimeType, null, "base64", data);
    }

    public static String getDataUri(String mimeType, String encoding, String data) {
        return URLUtil.getDataUri(mimeType, null, encoding, data);
    }

    public static String getDataUri(String mimeType, Charset charset, String encoding, String data) {
        StringBuilder builder = StrUtil.builder("data:");
        if (StrUtil.isNotBlank(mimeType)) {
            builder.append(mimeType);
        }
        if (null != charset) {
            builder.append(";charset=").append(charset.name());
        }
        if (StrUtil.isNotBlank(encoding)) {
            builder.append(';').append(encoding);
        }
        builder.append(',').append(data);
        return builder.toString();
    }

    public static long size(URL url) {
        if (URLUtil.isFileURL(url)) {
            File file = FileUtil.file(url);
            long length = file.length();
            if (length == 0L && !file.exists()) {
                throw new IORuntimeException("File not exist or size is zero!");
            }
            return length;
        }
        try {
            URLConnection con = url.openConnection();
            URLUtil.useCachesIfNecessary(con);
            if (con instanceof HttpURLConnection) {
                HttpURLConnection httpCon = (HttpURLConnection)con;
                httpCon.setRequestMethod("HEAD");
            }
            return con.getContentLengthLong();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void useCachesIfNecessary(URLConnection con) {
        con.setUseCaches(con.getClass().getSimpleName().startsWith("JNLP"));
    }
}

