/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.asymmetric;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.io.stream.FastByteArrayOutputStream;
import org.dromara.hutool.crypto.CipherWrapper;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.asymmetric.AbstractAsymmetricCrypto;
import org.dromara.hutool.crypto.asymmetric.AsymmetricAlgorithm;
import org.dromara.hutool.crypto.asymmetric.KeyType;

public class AsymmetricCrypto
extends AbstractAsymmetricCrypto<AsymmetricCrypto> {
    private static final long serialVersionUID = 1L;
    protected CipherWrapper cipherWrapper;
    protected int encryptBlockSize = -1;
    protected int decryptBlockSize = -1;

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public AsymmetricCrypto(String algorithm) {
        this(algorithm, (byte[])null, (byte[])null);
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, String privateKeyStr, String publicKeyStr) {
        this(algorithm.getValue(), SecureUtil.decode(privateKeyStr), SecureUtil.decode(publicKeyStr));
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public AsymmetricCrypto(AsymmetricAlgorithm algorithm, PrivateKey privateKey, PublicKey publicKey) {
        this(algorithm.getValue(), privateKey, publicKey);
    }

    public AsymmetricCrypto(String algorithm, String privateKeyBase64, String publicKeyBase64) {
        this(algorithm, Base64.decode(privateKeyBase64), Base64.decode(publicKeyBase64));
    }

    public AsymmetricCrypto(String algorithm, byte[] privateKey, byte[] publicKey) {
        this(algorithm, KeyUtil.generatePrivateKey(algorithm, privateKey), KeyUtil.generatePublicKey(algorithm, publicKey));
    }

    public AsymmetricCrypto(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super(algorithm, privateKey, publicKey);
    }

    public int getEncryptBlockSize() {
        return this.encryptBlockSize;
    }

    public void setEncryptBlockSize(int encryptBlockSize) {
        this.encryptBlockSize = encryptBlockSize;
    }

    public int getDecryptBlockSize() {
        return this.decryptBlockSize;
    }

    public void setDecryptBlockSize(int decryptBlockSize) {
        this.decryptBlockSize = decryptBlockSize;
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.cipherWrapper.getParams();
    }

    public void setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        this.cipherWrapper.setParams(algorithmParameterSpec);
    }

    public AsymmetricCrypto setRandom(SecureRandom random) {
        this.cipherWrapper.setRandom(random);
        return this;
    }

    @Override
    public AsymmetricCrypto init(String algorithm, PrivateKey privateKey, PublicKey publicKey) {
        super.init(algorithm, privateKey, publicKey);
        this.initCipher();
        return this;
    }

    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            int blockSize;
            Cipher cipher = this.initMode(1, key);
            if (this.encryptBlockSize < 0 && (blockSize = cipher.getBlockSize()) > 0) {
                this.encryptBlockSize = blockSize;
            }
            byte[] byArray = this.doFinal(data, this.encryptBlockSize < 0 ? data.length : this.encryptBlockSize);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] decrypt(byte[] data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            int blockSize;
            Cipher cipher = this.initMode(2, key);
            if (this.decryptBlockSize < 0 && (blockSize = cipher.getBlockSize()) > 0) {
                this.decryptBlockSize = blockSize;
            }
            byte[] byArray = this.doFinal(data, this.decryptBlockSize < 0 ? data.length : this.decryptBlockSize);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Cipher getCipher() {
        return this.cipherWrapper.getRaw();
    }

    protected void initCipher() {
        this.cipherWrapper = new CipherWrapper(this.algorithm);
    }

    private byte[] doFinal(byte[] data, int maxBlockSize) throws IllegalBlockSizeException, BadPaddingException, IOException {
        int dataLength = data.length;
        if (dataLength <= maxBlockSize) {
            return this.getCipher().doFinal(data, 0, dataLength);
        }
        return this.doFinalWithBlock(data, maxBlockSize);
    }

    private byte[] doFinalWithBlock(byte[] data, int maxBlockSize) throws IllegalBlockSizeException, BadPaddingException, IOException {
        int dataLength = data.length;
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        int offSet = 0;
        int remainLength = dataLength;
        while (remainLength > 0) {
            int blockSize = Math.min(remainLength, maxBlockSize);
            out.write(this.getCipher().doFinal(data, offSet, blockSize));
            remainLength = dataLength - (offSet += blockSize);
        }
        return out.toByteArray();
    }

    private Cipher initMode(int mode, Key key) throws InvalidAlgorithmParameterException, InvalidKeyException {
        return this.cipherWrapper.initMode(mode, key).getRaw();
    }
}

