/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.dromara.hutool.core.func.SerConsumer;
import org.dromara.hutool.db.AbstractDb;
import org.dromara.hutool.db.dialect.Dialect;
import org.dromara.hutool.db.dialect.DialectFactory;
import org.dromara.hutool.db.ds.DSUtil;
import org.dromara.hutool.db.transaction.TransactionLevel;
import org.dromara.hutool.log.LogUtil;

public class Db
extends AbstractDb<Db> {
    private static final long serialVersionUID = -3378415769645309514L;

    public static Db of() {
        return Db.of(DSUtil.getDS());
    }

    public static Db of(String group) {
        return Db.of(DSUtil.getDS(group));
    }

    public static Db of(DataSource ds) {
        return ds == null ? null : new Db(ds);
    }

    public static Db of(DataSource ds, Dialect dialect) {
        return new Db(ds, dialect);
    }

    public static Db of(DataSource ds, String driverClassName) {
        return new Db(ds, DialectFactory.newDialect(driverClassName));
    }

    public Db(DataSource ds) {
        this(ds, DialectFactory.getDialect(ds));
    }

    public Db(DataSource ds, String driverClassName) {
        this(ds, DialectFactory.newDialect(driverClassName));
    }

    public Db(DataSource ds, Dialect dialect) {
        super(ds, dialect);
    }

    public Db tx(SerConsumer<Db> func) throws SQLException {
        return this.tx(null, func);
    }

    public Db tx(TransactionLevel transactionLevel, SerConsumer<Db> func) throws SQLException {
        boolean autoCommit;
        Connection conn = this.getConnection();
        this.checkTransactionSupported(conn);
        if (null != transactionLevel) {
            int level = transactionLevel.getLevel();
            if (conn.getTransactionIsolation() < level) {
                conn.setTransactionIsolation(level);
            }
        }
        if (autoCommit = conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        try {
            func.accept(this);
            conn.commit();
        }
        catch (Throwable e) {
            this.quietRollback(conn);
            throw e instanceof SQLException ? (SQLException)e : new SQLException(e);
        }
        finally {
            this.quietSetAutoCommit(conn, autoCommit);
            this.closeConnection(conn);
        }
        return this;
    }

    private void quietRollback(Connection conn) {
        if (null != conn) {
            try {
                conn.rollback();
            }
            catch (Exception e) {
                LogUtil.error(e);
            }
        }
    }

    private void quietSetAutoCommit(Connection conn, Boolean autoCommit) {
        if (null != conn && null != autoCommit) {
            try {
                conn.setAutoCommit(autoCommit);
            }
            catch (Exception e) {
                LogUtil.error(e);
            }
        }
    }
}

