/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.pinyin.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.pinyin.PinyinException;
import org.dromara.hutool.extra.pinyin.engine.PinyinEngine;
import org.dromara.hutool.log.LogUtil;

public class PinyinEngineFactory {
    public static PinyinEngine getEngine() {
        return Singleton.get(PinyinEngine.class.getName(), PinyinEngineFactory::createEngine);
    }

    public static PinyinEngine createEngine() {
        PinyinEngine engine = PinyinEngineFactory.doCreateEngine();
        LogUtil.debug("Use [{}] Engine As Default.", StrUtil.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }

    private static PinyinEngine doCreateEngine() {
        PinyinEngine engine = SpiUtil.loadFirstAvailable(PinyinEngine.class);
        if (null != engine) {
            return engine;
        }
        throw new PinyinException("No pinyin jar found !Please add one of it to your project !");
    }
}

