/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.http.client.engine.okhttp;

import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.http.client.ClientConfig;
import org.dromara.hutool.http.client.Request;
import org.dromara.hutool.http.client.Response;
import org.dromara.hutool.http.client.engine.ClientEngine;
import org.dromara.hutool.http.client.engine.okhttp.BasicProxyAuthenticator;
import org.dromara.hutool.http.client.engine.okhttp.OkHttpRequestBody;
import org.dromara.hutool.http.client.engine.okhttp.OkHttpResponse;
import org.dromara.hutool.http.proxy.HttpProxy;
import org.dromara.hutool.http.ssl.SSLInfo;

public class OkHttpEngine
implements ClientEngine {
    private ClientConfig config;
    private OkHttpClient client = new OkHttpClient();

    @Override
    public OkHttpEngine init(ClientConfig config) {
        this.config = config;
        this.client = null;
        return this;
    }

    @Override
    public Response send(Request message) {
        okhttp3.Response response;
        this.initEngine();
        try {
            response = this.client.newCall(OkHttpEngine.buildRequest(message)).execute();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return new OkHttpResponse(response, message.charset());
    }

    @Override
    public Object getRawEngine() {
        return this.client;
    }

    @Override
    public void close() {
    }

    private void initEngine() {
        if (null != this.client) {
            return;
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        ClientConfig config = this.config;
        if (null != config) {
            SSLInfo sslInfo;
            int readTimeout;
            int connectionTimeout = config.getConnectionTimeout();
            if (connectionTimeout > 0) {
                builder.connectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS);
            }
            if ((readTimeout = config.getReadTimeout()) > 0) {
                builder.readTimeout((long)config.getReadTimeout(), TimeUnit.MILLISECONDS).writeTimeout((long)config.getReadTimeout(), TimeUnit.MILLISECONDS);
            }
            if (null != (sslInfo = config.getSslInfo())) {
                builder.sslSocketFactory(sslInfo.getSocketFactory(), sslInfo.getTrustManager());
            }
            OkHttpEngine.setProxy(builder, config);
        }
        builder.followRedirects(false);
        this.client = builder.build();
    }

    private static okhttp3.Request buildRequest(Request message) {
        Request.Builder builder = new Request.Builder().url(message.url().toURL());
        String method = message.method().name();
        if (HttpMethod.permitsRequestBody((String)method)) {
            builder.method(method, (RequestBody)new OkHttpRequestBody(message.body()));
        } else {
            builder.method(method, null);
        }
        message.headers().forEach((key, values) -> values.forEach(value -> builder.addHeader(key, value)));
        return builder.build();
    }

    private static void setProxy(OkHttpClient.Builder builder, ClientConfig config) {
        HttpProxy proxy = config.getProxy();
        if (null != proxy) {
            builder.proxy((Proxy)proxy);
            PasswordAuthentication auth = proxy.getAuth();
            if (null != auth) {
                builder.proxyAuthenticator((Authenticator)new BasicProxyAuthenticator(auth));
            }
        }
    }
}

