/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.setting.props;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.func.LambdaInfo;
import org.dromara.hutool.core.func.LambdaUtil;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.core.func.SerSupplier;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.io.resource.Resource;
import org.dromara.hutool.core.io.resource.ResourceUtil;
import org.dromara.hutool.core.io.resource.UrlResource;
import org.dromara.hutool.core.io.watch.SimpleWatcher;
import org.dromara.hutool.core.io.watch.WatchMonitor;
import org.dromara.hutool.core.io.watch.WatchUtil;
import org.dromara.hutool.core.io.watch.Watcher;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.getter.TypeGetter;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.log.LogUtil;

public final class Props
extends Properties
implements TypeGetter<CharSequence> {
    private static final long serialVersionUID = 1935981579709590740L;
    public static final String EXT_NAME = "properties";
    private Resource resource;
    private WatchMonitor watchMonitor;
    private transient Charset charset = CharsetUtil.ISO_8859_1;

    public static Props of() {
        return new Props();
    }

    public static Props of(String resource) {
        return new Props(resource);
    }

    public static Props of(String resource, Charset charset) {
        return new Props(resource, charset);
    }

    public Props() {
    }

    public Props(String path) {
        this(path, null);
    }

    public Props(String path, Charset charset) {
        Assert.notBlank(path, "Blank properties file path !", new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(ResourceUtil.getResource(path));
    }

    public Props(File propertiesFile) {
        this(propertiesFile, null);
    }

    public Props(File propertiesFile, Charset charset) {
        Assert.notNull(propertiesFile, "Null properties file!", new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(ResourceUtil.getResource(propertiesFile));
    }

    public Props(Resource resource, Charset charset) {
        Assert.notNull(resource, "Null properties URL !", new Object[0]);
        if (null != charset) {
            this.charset = charset;
        }
        this.load(resource);
    }

    public Props(Properties properties) {
        if (MapUtil.isNotEmpty(properties)) {
            this.putAll((Map<?, ?>)properties);
        }
    }

    public void load(URL url) {
        this.load(new UrlResource(url));
    }

    public void load(Resource resource) {
        Assert.notNull(resource, "Props resource must be not null!", new Object[0]);
        this.resource = resource;
        ResourceUtil.loadTo(this, resource, this.charset);
    }

    public void load() {
        this.load(this.resource);
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            Assert.notNull(this.resource, "Properties resource must be not null!", new Object[0]);
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
            }
            this.watchMonitor = WatchUtil.createModify(this.resource.getUrl(), (Watcher)new SimpleWatcher(){

                @Override
                public void onModify(WatchEvent<?> event, Path currentPath) {
                    Props.this.load();
                }
            });
            this.watchMonitor.start();
        } else {
            IoUtil.closeQuietly(this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    @Override
    public Object getObj(CharSequence key, Object defaultValue) {
        return ObjUtil.defaultIfNull(this.getProperty(StrUtil.str(key)), defaultValue);
    }

    public <P, T> T get(SerFunction<P, T> func) {
        LambdaInfo lambdaInfo = LambdaUtil.resolve(func);
        return this.get(lambdaInfo.getFieldName(), lambdaInfo.getReturnType());
    }

    public String getAndRemoveStr(String ... keys) {
        String key;
        Object value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && null == (value = this.remove(key = stringArray[i])); ++i) {
        }
        return (String)value;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this);
        return properties;
    }

    public <T> T toBean(Class<T> beanClass) {
        return this.toBean(beanClass, null);
    }

    public <T> T toBean(Class<T> beanClass, String prefix) {
        T bean = ConstructorUtil.newInstanceIfPossible(beanClass);
        return this.fillBean(bean, prefix);
    }

    public <T> T fillBean(T bean, String prefix) {
        prefix = StrUtil.emptyIfNull(StrUtil.addSuffixIfNot(prefix, "."));
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            String key = (String)entry.getKey();
            if (!StrUtil.startWith((CharSequence)key, prefix)) continue;
            try {
                BeanUtil.setProperty(bean, StrUtil.subSuf(key, prefix.length()), entry.getValue());
            }
            catch (Exception e) {
                LogUtil.debug("Ignore property: [{}],because of: {}", key, e);
            }
        }
        return bean;
    }

    public void set(String key, Object value) {
        super.setProperty(key, value.toString());
    }

    public Props setFields(SerSupplier<?> ... fields) {
        Arrays.stream(fields).forEach((? super T f) -> this.set(LambdaUtil.getFieldName(f), f.get()));
        return this;
    }

    public void store(String absolutePath) throws IORuntimeException {
        BufferedWriter writer = null;
        try {
            writer = FileUtil.getWriter(absolutePath, this.charset, false);
            super.store(writer, null);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e, "Store properties to [{}] error!", absolutePath);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(writer);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(writer);
    }

    public void store(String path, Class<?> clazz) {
        this.store(FileUtil.getAbsolutePath(path, clazz));
    }
}

