/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.codec.binary;

import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.codec.Decoder;
import org.dromara.hutool.core.lang.mutable.MutableInt;

public class Base64Decoder
implements Decoder<byte[], byte[]> {
    public static Base64Decoder INSTANCE = new Base64Decoder();
    private static final byte PADDING = -2;
    private final byte[] DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    @Override
    public byte[] decode(byte[] in) {
        if (ArrayUtil.isEmpty(in)) {
            return in;
        }
        return this.decode(in, 0, in.length);
    }

    public byte[] decode(byte[] in, int pos, int length) {
        if (ArrayUtil.isEmpty(in)) {
            return in;
        }
        MutableInt offset = new MutableInt(pos);
        int maxPos = pos + length - 1;
        int octetId = 0;
        byte[] octet = new byte[length * 3 / 4];
        while (offset.intValue() <= maxPos) {
            byte sestet0 = this.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet1 = this.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet2 = this.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet3 = this.getNextValidDecodeByte(in, offset, maxPos);
            if (-2 != sestet1) {
                octet[octetId++] = (byte)(sestet0 << 2 | sestet1 >>> 4);
            }
            if (-2 != sestet2) {
                octet[octetId++] = (byte)((sestet1 & 0xF) << 4 | sestet2 >>> 2);
            }
            if (-2 == sestet3) continue;
            octet[octetId++] = (byte)((sestet2 & 3) << 6 | sestet3);
        }
        if (octetId == octet.length) {
            return octet;
        }
        return ArrayUtil.copy(octet, new byte[octetId], octetId);
    }

    public boolean isBase64Code(byte octet) {
        return octet == 61 || octet >= 0 && octet < this.DECODE_TABLE.length && this.DECODE_TABLE[octet] != -1;
    }

    private byte getNextValidDecodeByte(byte[] in, MutableInt pos, int maxPos) {
        while (pos.intValue() <= maxPos) {
            byte decodeByte;
            byte base64Byte = in[pos.intValue()];
            pos.increment();
            if (base64Byte <= -1 || (decodeByte = this.DECODE_TABLE[base64Byte]) <= -1) continue;
            return decodeByte;
        }
        return -2;
    }
}

