/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.collection.iter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.dromara.hutool.core.lang.Assert;

public class FilterIter<E>
implements Iterator<E> {
    private final Iterator<? extends E> iterator;
    private final Predicate<? super E> filter;
    private E nextObject;
    private boolean nextObjectSet = false;

    public FilterIter(Iterator<? extends E> iterator, Predicate<? super E> filter) {
        this.iterator = Assert.notNull(iterator);
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        return this.nextObjectSet || this.setNextObject();
    }

    @Override
    public E next() {
        if (!this.nextObjectSet && !this.setNextObject()) {
            throw new NoSuchElementException();
        }
        this.nextObjectSet = false;
        return this.nextObject;
    }

    @Override
    public void remove() {
        if (this.nextObjectSet) {
            throw new IllegalStateException("remove() cannot be called");
        }
        this.iterator.remove();
    }

    public Iterator<? extends E> getIterator() {
        return this.iterator;
    }

    public Predicate<? super E> getFilter() {
        return this.filter;
    }

    private boolean setNextObject() {
        while (this.iterator.hasNext()) {
            E object = this.iterator.next();
            if (null != this.filter && !this.filter.test(object)) continue;
            this.nextObject = object;
            this.nextObjectSet = true;
            return true;
        }
        return false;
    }
}

