/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.tokenizer.engine;

import org.dromara.hutool.core.lang.Singleton;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.tokenizer.TokenizerException;
import org.dromara.hutool.extra.tokenizer.engine.TokenizerEngine;
import org.dromara.hutool.log.LogUtil;

public class TokenizerEngineFactory {
    public static TokenizerEngine getEngine() {
        TokenizerEngine engine = Singleton.get(TokenizerEngine.class.getName(), TokenizerEngineFactory::createEngine);
        LogUtil.debug("Use [{}] Tokenizer Engine As Default.", StrUtil.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }

    public static TokenizerEngine createEngine() {
        return TokenizerEngineFactory.doCreateEngine();
    }

    private static TokenizerEngine doCreateEngine() {
        TokenizerEngine engine = SpiUtil.loadFirstAvailable(TokenizerEngine.class);
        if (null != engine) {
            return engine;
        }
        throw new TokenizerException("No tokenizer found !Please add some tokenizer jar to your project !");
    }
}

