/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.bean.copier;

import java.lang.reflect.Type;
import java.util.Map;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.PropDesc;
import org.dromara.hutool.core.bean.copier.AbsCopier;
import org.dromara.hutool.core.bean.copier.CopyOptions;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.mutable.MutableEntry;
import org.dromara.hutool.core.map.CaseInsensitiveMap;
import org.dromara.hutool.core.map.MapWrapper;
import org.dromara.hutool.core.reflect.TypeUtil;
import org.dromara.hutool.core.text.StrUtil;

public class MapToBeanCopier<T>
extends AbsCopier<Map<?, ?>, T> {
    private final Type targetType;

    public MapToBeanCopier(Map<?, ?> source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        Object raw;
        if (source instanceof MapWrapper && (raw = ((MapWrapper)source).getRaw()) instanceof CaseInsensitiveMap) {
            copyOptions.setIgnoreCase(true);
        }
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Class<?> actualEditable = this.target.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropDesc> targetPropDescMap = BeanUtil.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        ((Map)this.source).forEach((sKey, sValue) -> {
            if (null == sKey) {
                return;
            }
            MutableEntry<String, Object> entry = this.copyOptions.editField(sKey.toString(), sValue);
            if (null == entry) {
                return;
            }
            String sFieldName = entry.getKey();
            if (null == sFieldName) {
                return;
            }
            PropDesc tDesc = this.findPropDesc(targetPropDescMap, sFieldName);
            if (null == tDesc || !tDesc.isWritable(this.copyOptions.transientSupport)) {
                return;
            }
            Object newValue = entry.getValue();
            if (!this.copyOptions.testPropertyFilter(tDesc.getField(), newValue)) {
                return;
            }
            Type fieldType = TypeUtil.getActualType(this.targetType, tDesc.getFieldType());
            newValue = this.copyOptions.convertField(fieldType, newValue);
            tDesc.setValue(this.target, newValue, this.copyOptions.ignoreNullValue, this.copyOptions.ignoreError, this.copyOptions.override);
        });
        return (T)this.target;
    }

    private PropDesc findPropDesc(Map<String, PropDesc> targetPropDescMap, String sKeyStr) {
        PropDesc propDesc = targetPropDescMap.get(sKeyStr);
        if (null != propDesc) {
            return propDesc;
        }
        sKeyStr = StrUtil.toCamelCase(sKeyStr);
        propDesc = targetPropDescMap.get(sKeyStr);
        return propDesc;
    }
}

