/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.watch.watchers;

import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.dromara.hutool.core.io.watch.Watcher;
import org.dromara.hutool.core.lang.Chain;

public class WatcherChain
implements Watcher,
Chain<Watcher, WatcherChain> {
    private final List<Watcher> chain;

    public static WatcherChain of(Watcher ... watchers) {
        return new WatcherChain(watchers);
    }

    public WatcherChain(Watcher ... watchers) {
        this.chain = Arrays.asList(watchers);
    }

    @Override
    public void onCreate(WatchEvent<?> event, Path currentPath) {
        for (Watcher watcher : this.chain) {
            watcher.onCreate(event, currentPath);
        }
    }

    @Override
    public void onModify(WatchEvent<?> event, Path currentPath) {
        for (Watcher watcher : this.chain) {
            watcher.onModify(event, currentPath);
        }
    }

    @Override
    public void onDelete(WatchEvent<?> event, Path currentPath) {
        for (Watcher watcher : this.chain) {
            watcher.onDelete(event, currentPath);
        }
    }

    @Override
    public void onOverflow(WatchEvent<?> event, Path currentPath) {
        for (Watcher watcher : this.chain) {
            watcher.onOverflow(event, currentPath);
        }
    }

    @Override
    public Iterator<Watcher> iterator() {
        return this.chain.iterator();
    }

    @Override
    public WatcherChain addChain(Watcher element) {
        this.chain.add(element);
        return this;
    }
}

