/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.dialect.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Set;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrValidator;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.Page;
import org.dromara.hutool.db.StatementUtil;
import org.dromara.hutool.db.dialect.Dialect;
import org.dromara.hutool.db.dialect.DialectName;
import org.dromara.hutool.db.sql.Condition;
import org.dromara.hutool.db.sql.Query;
import org.dromara.hutool.db.sql.QuoteWrapper;
import org.dromara.hutool.db.sql.SqlBuilder;

public class AnsiSqlDialect
implements Dialect {
    private static final long serialVersionUID = 2088101129774974580L;
    protected QuoteWrapper quoteWrapper = new QuoteWrapper();

    @Override
    public QuoteWrapper getWrapper() {
        return this.quoteWrapper;
    }

    @Override
    public void setWrapper(QuoteWrapper quoteWrapper) {
        this.quoteWrapper = quoteWrapper;
    }

    @Override
    public PreparedStatement psForInsert(Connection conn, Entity entity) throws SQLException {
        SqlBuilder insert = SqlBuilder.of(this.quoteWrapper).insert(entity, this.dialectName());
        return StatementUtil.prepareStatement(conn, insert);
    }

    @Override
    public PreparedStatement psForInsertBatch(Connection conn, Entity ... entities) throws SQLException {
        if (ArrayUtil.isEmpty(entities)) {
            throw new DbRuntimeException("Entities for batch insert is empty !");
        }
        SqlBuilder insert = SqlBuilder.of(this.quoteWrapper).insert(entities[0], this.dialectName());
        Set<String> fields = CollUtil.remove(entities[0].keySet(), StrValidator::isBlank);
        return StatementUtil.prepareStatementForBatch(conn, insert.build(), fields, entities);
    }

    @Override
    public PreparedStatement psForDelete(Connection conn, Query query) throws SQLException {
        Assert.notNull(query, "query must be not null !", new Object[0]);
        Condition[] where = query.getWhere();
        if (ArrayUtil.isEmpty(where)) {
            throw new SQLException("No 'WHERE' condition, we can't prepared statement for delete everything.");
        }
        SqlBuilder delete = SqlBuilder.of(this.quoteWrapper).delete(query.getFirstTableName()).where(where);
        return StatementUtil.prepareStatement(conn, delete);
    }

    @Override
    public PreparedStatement psForUpdate(Connection conn, Entity entity, Query query) throws SQLException {
        Assert.notNull(query, "query must be not null !", new Object[0]);
        Condition[] where = query.getWhere();
        if (ArrayUtil.isEmpty(where)) {
            throw new SQLException("No 'WHERE' condition, we can't prepare statement for update everything.");
        }
        SqlBuilder update = SqlBuilder.of(this.quoteWrapper).update(entity).where(where);
        return StatementUtil.prepareStatement(conn, update);
    }

    @Override
    public PreparedStatement psForFind(Connection conn, Query query) throws SQLException {
        return this.psForPage(conn, query);
    }

    @Override
    public PreparedStatement psForPage(Connection conn, Query query) throws SQLException {
        Assert.notNull(query, "query must be not null !", new Object[0]);
        if (ArrayUtil.hasBlank(query.getTableNames())) {
            throw new DbRuntimeException("Table name must be not empty !");
        }
        SqlBuilder find = SqlBuilder.of(this.quoteWrapper).query(query);
        return this.psForPage(conn, find, query.getPage());
    }

    @Override
    public PreparedStatement psForPage(Connection conn, SqlBuilder sqlBuilder, Page page) throws SQLException {
        if (null != page) {
            sqlBuilder = this.wrapPageSql(sqlBuilder.orderBy(page.getOrders()), page);
        }
        return StatementUtil.prepareStatement(conn, sqlBuilder);
    }

    protected SqlBuilder wrapPageSql(SqlBuilder find, Page page) {
        return find.append(" limit ").append(page.getPageSize()).append(" offset ").append(page.getStartPosition());
    }

    @Override
    public String dialectName() {
        return DialectName.ANSI.name();
    }
}

