/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.compress.extractor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.compress.CompressException;
import org.dromara.hutool.extra.compress.extractor.Extractor;

public class StreamExtractor
implements Extractor {
    private final ArchiveInputStream in;

    public StreamExtractor(Charset charset, File file) {
        this(charset, null, file);
    }

    public StreamExtractor(Charset charset, String archiverName, File file) {
        this(charset, archiverName, FileUtil.getInputStream(file));
    }

    public StreamExtractor(Charset charset, InputStream in) {
        this(charset, null, in);
    }

    public StreamExtractor(Charset charset, String archiverName, InputStream in) {
        block7: {
            if (in instanceof ArchiveInputStream) {
                this.in = (ArchiveInputStream)in;
                return;
            }
            ArchiveStreamFactory factory = new ArchiveStreamFactory(charset.name());
            try {
                in = IoUtil.toBuffered(in);
                if (StrUtil.isBlank(archiverName)) {
                    this.in = factory.createArchiveInputStream(in);
                    break block7;
                }
                if ("tgz".equalsIgnoreCase(archiverName) || "tar.gz".equalsIgnoreCase(archiverName)) {
                    try {
                        this.in = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(in));
                        break block7;
                    }
                    catch (IOException e) {
                        throw new IORuntimeException(e);
                    }
                }
                this.in = factory.createArchiveInputStream(archiverName, in);
            }
            catch (ArchiveException e) {
                IoUtil.closeQuietly(in);
                throw new CompressException(e);
            }
        }
    }

    @Override
    public InputStream getFirst(Predicate<ArchiveEntry> predicate) {
        ArchiveInputStream in = this.in;
        try {
            ArchiveEntry entry;
            while (null != (entry = in.getNextEntry())) {
                if (null != predicate && !predicate.test(entry) || entry.isDirectory() || !in.canReadEntryData(entry)) continue;
                return in;
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return null;
    }

    @Override
    public void extract(File targetDir, Predicate<ArchiveEntry> predicate) {
        try {
            this.extractInternal(targetDir, predicate);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        finally {
            this.close();
        }
    }

    private void extractInternal(File targetDir, Predicate<ArchiveEntry> predicate) throws IOException {
        ArchiveEntry entry;
        Assert.isTrue(null != targetDir && (!targetDir.exists() || targetDir.isDirectory()), "target must be dir.", new Object[0]);
        ArchiveInputStream in = this.in;
        while (null != (entry = in.getNextEntry())) {
            if (null != predicate && !predicate.test(entry) || !in.canReadEntryData(entry)) continue;
            File outItemFile = FileUtil.file(targetDir, entry.getName());
            if (entry.isDirectory()) {
                outItemFile.mkdirs();
                continue;
            }
            FileUtil.writeFromStream((InputStream)in, outItemFile, false);
        }
    }

    @Override
    public void close() {
        IoUtil.closeQuietly(new AutoCloseable[]{this.in});
    }
}

