/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.qrcode;

import com.google.zxing.common.BitMatrix;
import org.dromara.hutool.core.lang.ansi.AnsiElement;
import org.dromara.hutool.core.lang.ansi.AnsiEncoder;
import org.dromara.hutool.extra.qrcode.QrConfig;
import org.dromara.hutool.swing.img.color.ColorUtil;

public class QrAsciiArt {
    private final BitMatrix matrix;
    private final QrConfig qrConfig;

    public QrAsciiArt(BitMatrix matrix, QrConfig qrConfig) {
        this.matrix = matrix;
        this.qrConfig = qrConfig;
    }

    public String toString() {
        int width = this.matrix.getWidth();
        int height = this.matrix.getHeight();
        AnsiElement foreground = this.qrConfig.foreColor == null ? null : ColorUtil.toAnsiColor(this.qrConfig.foreColor, true, false);
        AnsiElement background = this.qrConfig.backColor == null ? null : ColorUtil.toAnsiColor(this.qrConfig.backColor, true, true);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i <= height; i += 2) {
            StringBuilder rowBuilder = new StringBuilder();
            for (int j = 0; j < width; ++j) {
                boolean bt;
                boolean tp = this.matrix.get(i, j);
                boolean bl = bt = i + 1 >= height || this.matrix.get(i + 1, j);
                if (tp && bt) {
                    rowBuilder.append(' ');
                    continue;
                }
                if (tp) {
                    rowBuilder.append('\u2584');
                    continue;
                }
                if (bt) {
                    rowBuilder.append('\u2580');
                    continue;
                }
                rowBuilder.append('\u2588');
            }
            builder.append(AnsiEncoder.encode(foreground, background, rowBuilder)).append('\n');
        }
        return builder.toString();
    }
}

