/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.ssh.engine.ganymed;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.LocalPortForwarder;
import ch.ethz.ssh2.StreamGobbler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.extra.ssh.Connector;
import org.dromara.hutool.extra.ssh.Session;
import org.dromara.hutool.extra.ssh.engine.ganymed.GanymedUtil;

public class GanymedSession
implements Session {
    private Connection connection;
    private final ch.ethz.ssh2.Session raw;
    private Map<Integer, LocalPortForwarder> localPortForwarderMap;

    public GanymedSession(Connector connector) {
        this(GanymedUtil.openConnection(connector));
    }

    public GanymedSession(Connection connection) {
        this(GanymedUtil.openSession(connection));
        this.connection = connection;
    }

    private GanymedSession(ch.ethz.ssh2.Session raw) {
        this.raw = raw;
    }

    @Override
    public ch.ethz.ssh2.Session getRaw() {
        return this.raw;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.raw != null) {
            this.raw.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public boolean bindLocalPort(String remoteHost, int remotePort, int localPort) throws IORuntimeException {
        return this.bindLocalPort(remoteHost, remotePort, "127.0.0.1", localPort);
    }

    public boolean bindLocalPort(String remoteHost, int remotePort, String localHost, int localPort) throws IORuntimeException {
        LocalPortForwarder localPortForwarder;
        try {
            localPortForwarder = this.connection.createLocalPortForwarder(new InetSocketAddress(localHost, localPort), remoteHost, remotePort);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null == this.localPortForwarderMap) {
            this.localPortForwarderMap = new HashMap<Integer, LocalPortForwarder>();
        }
        this.localPortForwarderMap.put(localPort, localPortForwarder);
        return true;
    }

    public void unBindLocalPort(int localPort) throws IORuntimeException {
        if (MapUtil.isEmpty(this.localPortForwarderMap)) {
            return;
        }
        LocalPortForwarder localPortForwarder = this.localPortForwarderMap.remove(localPort);
        if (null != localPortForwarder) {
            try {
                localPortForwarder.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean bindRemotePort(int bindPort, String host, int port) throws IORuntimeException {
        try {
            this.connection.requestRemotePortForwarding("127.0.0.1", bindPort, host, port);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return true;
    }

    public void unBindRemotePort(int localPort) throws IORuntimeException {
        try {
            this.connection.cancelRemotePortForwarding(localPort);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public String exec(String cmd, Charset charset, OutputStream errStream) {
        if (null == charset) {
            charset = CharsetUtil.UTF_8;
        }
        try {
            this.raw.execCommand(cmd, charset.name());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (null != errStream) {
            IoUtil.copy((InputStream)new StreamGobbler(this.raw.getStderr()), errStream);
        }
        return IoUtil.read((InputStream)new StreamGobbler(this.raw.getStdout()), charset);
    }

    public String execByShell(String cmd, Charset charset, OutputStream errStream) {
        if (null == charset) {
            charset = CharsetUtil.UTF_8;
        }
        try {
            this.raw.requestDumbPTY();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        IoUtil.write(this.raw.getStdin(), charset, true, cmd);
        if (null != errStream) {
            IoUtil.copy((InputStream)new StreamGobbler(this.raw.getStderr()), errStream);
        }
        return IoUtil.read((InputStream)new StreamGobbler(this.raw.getStdout()), charset);
    }
}

