/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.ReaderWrapper;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.json.InternalJSONUtil;
import org.dromara.hutool.json.JSONArray;
import org.dromara.hutool.json.JSONConfig;
import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONObject;

public class JSONTokener
extends ReaderWrapper {
    private long character = 1L;
    private boolean eof = false;
    private long index = 0L;
    private long line = 1L;
    private char previous = '\u0000';
    private boolean usePrevious = false;
    private final JSONConfig config;

    public JSONTokener(InputStream inputStream, JSONConfig config) throws JSONException {
        this(IoUtil.toUtf8Reader(inputStream), config);
    }

    public JSONTokener(CharSequence s, JSONConfig config) {
        this(new StringReader(StrUtil.str(s)), config);
    }

    public JSONTokener(Reader reader, JSONConfig config) {
        super(IoUtil.toMarkSupport(reader));
        this.config = config;
    }

    public void back() throws JSONException {
        if (this.usePrevious || this.index <= 0L) {
            throw new JSONException("Stepping back two steps is not supported");
        }
        --this.index;
        --this.character;
        this.usePrevious = true;
        this.eof = false;
    }

    public boolean end() {
        return this.eof && !this.usePrevious;
    }

    public boolean more() throws JSONException {
        this.next();
        if (this.end()) {
            return false;
        }
        this.back();
        return true;
    }

    public char next() throws JSONException {
        int c;
        if (this.usePrevious) {
            this.usePrevious = false;
            c = this.previous;
        } else {
            try {
                c = this.read();
            }
            catch (IOException exception) {
                throw new JSONException(exception);
            }
            if (c <= 0) {
                this.eof = true;
                c = 0;
            }
        }
        ++this.index;
        if (this.previous == '\r') {
            ++this.line;
            this.character = c == 10 ? 0L : 1L;
        } else if (c == 10) {
            ++this.line;
            this.character = 0L;
        } else {
            ++this.character;
        }
        this.previous = (char)c;
        return this.previous;
    }

    protected char getPrevious() {
        return this.previous;
    }

    public char next(char c) throws JSONException {
        char n = this.next();
        if (n != c) {
            throw this.syntaxError("Expected '" + c + "' and instead saw '" + n + "'");
        }
        return n;
    }

    public String next(int n) throws JSONException {
        if (n == 0) {
            return "";
        }
        char[] chars = new char[n];
        for (int pos = 0; pos < n; ++pos) {
            chars[pos] = this.next();
            if (!this.end()) continue;
            throw this.syntaxError("Substring bounds error");
        }
        return new String(chars);
    }

    public char nextClean() throws JSONException {
        char c;
        while ((c = this.next()) != '\u0000' && c <= ' ') {
        }
        return c;
    }

    public String nextString(char quote) throws JSONException {
        StringBuilder sb = new StringBuilder();
        block14: while (true) {
            char c = this.next();
            switch (c) {
                case '\u0000': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\n': 
                case '\r': {
                    sb.append(c);
                    continue block14;
                }
                case '\\': {
                    c = this.next();
                    switch (c) {
                        case 'b': {
                            sb.append('\b');
                            continue block14;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block14;
                        }
                        case 'n': {
                            sb.append('\n');
                            continue block14;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block14;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block14;
                        }
                        case 'u': {
                            sb.append((char)Integer.parseInt(this.next(4), 16));
                            continue block14;
                        }
                        case '\"': 
                        case '\'': 
                        case '/': 
                        case '\\': {
                            sb.append(c);
                            continue block14;
                        }
                    }
                    throw this.syntaxError("Illegal escape.");
                }
            }
            if (c == quote) {
                return sb.toString();
            }
            sb.append(c);
        }
    }

    public String nextTo(char delimiter) throws JSONException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            char c;
            if ((c = this.next()) == delimiter || c == '\u0000' || c == '\n' || c == '\r') {
                if (c != '\u0000') {
                    this.back();
                }
                return sb.toString().trim();
            }
            sb.append(c);
        }
    }

    public String nextTo(String delimiters) throws JSONException {
        StringBuilder sb = new StringBuilder();
        while (true) {
            char c;
            if (delimiters.indexOf(c = this.next()) >= 0 || c == '\u0000' || c == '\n' || c == '\r') {
                if (c != '\u0000') {
                    this.back();
                }
                return sb.toString().trim();
            }
            sb.append(c);
        }
    }

    public Object nextValue(boolean getOnlyStringValue) throws JSONException {
        char c = this.nextClean();
        switch (c) {
            case '\"': 
            case '\'': {
                return this.nextString(c);
            }
            case '{': {
                if (getOnlyStringValue) {
                    throw this.syntaxError("String value must not begin with '{'");
                }
                this.back();
                try {
                    return new JSONObject(this, this.config);
                }
                catch (StackOverflowError e) {
                    throw new JSONException("JSONObject depth too large to process.", e);
                }
            }
            case '[': {
                if (getOnlyStringValue) {
                    throw this.syntaxError("String value must not begin with '['");
                }
                this.back();
                try {
                    return new JSONArray(this, this.config);
                }
                catch (StackOverflowError e) {
                    throw new JSONException("JSONArray depth too large to process.", e);
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
            sb.append(c);
            c = this.next();
        }
        this.back();
        String valueString = sb.toString().trim();
        if (valueString.isEmpty()) {
            throw this.syntaxError("Missing value");
        }
        return getOnlyStringValue ? valueString : InternalJSONUtil.stringToValue(valueString);
    }

    public char skipTo(char to) throws JSONException {
        char c;
        try {
            long startIndex = this.index;
            long startCharacter = this.character;
            long startLine = this.line;
            this.mark(1000000);
            do {
                if ((c = this.next()) != '\u0000') continue;
                this.reset();
                this.index = startIndex;
                this.character = startCharacter;
                this.line = startLine;
                return c;
            } while (c != to);
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
        this.back();
        return c;
    }

    public JSONException syntaxError(String message) {
        return new JSONException(message + this);
    }

    public String toString() {
        return " at " + this.index + " [character " + this.character + " line " + this.line + "]";
    }
}

