/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.collection.set.SetUtil;

public class CollectionOperation<E> {
    private final Collection<E>[] colls;

    @SafeVarargs
    public static <E> CollectionOperation<E> of(Collection<E> ... colls) {
        return new CollectionOperation<E>(colls);
    }

    public CollectionOperation(Collection<E>[] colls) {
        this.colls = colls;
    }

    public Collection<E> union() {
        Collection<E>[] colls = this.colls;
        if (ArrayUtil.isEmpty(colls)) {
            return ListUtil.zero();
        }
        Collection<E> result = colls[0];
        for (int i = 1; i < colls.length; ++i) {
            result = CollectionOperation._union(result, colls[i]);
        }
        return result;
    }

    public Set<E> unionDistinct() {
        Collection<E>[] colls = this.colls;
        int totalLength = 0;
        for (Collection<E> set : colls) {
            if (!CollUtil.isNotEmpty(set)) continue;
            totalLength += set.size();
        }
        HashSet<E> result = new HashSet<E>(totalLength, 1.0f);
        for (Collection<E> set : colls) {
            if (!CollUtil.isNotEmpty(set)) continue;
            result.addAll(set);
        }
        return result;
    }

    public List<E> unionAll() {
        Collection<E>[] colls = this.colls;
        if (ArrayUtil.isEmpty(colls)) {
            return ListUtil.zero();
        }
        int totalSize = 0;
        for (Collection<E> coll : colls) {
            if (!CollUtil.isNotEmpty(coll)) continue;
            totalSize += CollUtil.size(coll);
        }
        if (totalSize == 0) {
            return ListUtil.zero();
        }
        ArrayList<E> result = new ArrayList<E>(totalSize);
        for (Collection<E> coll : colls) {
            if (!CollUtil.isNotEmpty(coll)) continue;
            result.addAll(coll);
        }
        return result;
    }

    public Collection<E> intersection() {
        Collection<E>[] colls = this.colls;
        if (ArrayUtil.isEmpty(colls)) {
            return ListUtil.zero();
        }
        Collection<E> result = colls[0];
        for (int i = 1; i < colls.length; ++i) {
            result = CollectionOperation._intersection(result, colls[i]);
        }
        return result;
    }

    public Set<E> intersectionDistinct() {
        Collection<E>[] colls = this.colls;
        if (ArrayUtil.isEmpty(colls)) {
            return SetUtil.zeroLinked();
        }
        for (Collection<E> coll : colls) {
            if (!CollUtil.isEmpty(coll)) continue;
            return SetUtil.zeroLinked();
        }
        HashSet<E> result = SetUtil.of(true, colls[0]);
        for (int i = 1; i < colls.length; ++i) {
            if (!CollUtil.isNotEmpty(colls[i])) continue;
            result.retainAll(colls[i]);
        }
        return result;
    }

    public Collection<E> disjunction() {
        Collection<E>[] colls = this.colls;
        if (ArrayUtil.isEmpty(colls)) {
            return ListUtil.zero();
        }
        Collection<E> result = colls[0];
        for (int i = 1; i < colls.length; ++i) {
            result = CollectionOperation._disjunction(result, colls[i]);
        }
        return result;
    }

    public List<E> subtract() {
        Collection<E>[] colls = this.colls;
        if (ArrayUtil.isEmpty(colls)) {
            return ListUtil.zero();
        }
        ArrayList<E> result = ListUtil.of(colls[0]);
        for (int i = 1; i < colls.length; ++i) {
            result.removeAll(colls[i]);
        }
        return result;
    }

    private static <T> Collection<T> _union(Collection<T> coll1, Collection<T> coll2) {
        if (CollUtil.isEmpty(coll1)) {
            return ListUtil.of(coll2);
        }
        if (CollUtil.isEmpty(coll2)) {
            return ListUtil.of(coll1);
        }
        Map<T, Integer> map1 = CollUtil.countMap(coll1);
        Map<T, Integer> map2 = CollUtil.countMap(coll2);
        Set elements = CollectionOperation.of(map1.keySet(), map2.keySet()).unionDistinct();
        ArrayList list = new ArrayList(coll1.size() + coll2.size());
        for (Object t : elements) {
            int amount = Math.max(map1.getOrDefault(t, 0), map2.getOrDefault(t, 0));
            for (int i = 0; i < amount; ++i) {
                list.add(t);
            }
        }
        return list;
    }

    private static <E> Collection<E> _intersection(Collection<E> coll1, Collection<E> coll2) {
        if (CollUtil.isEmpty(coll1) || CollUtil.isEmpty(coll2)) {
            return ListUtil.zero();
        }
        Map<E, Integer> map1 = CollUtil.countMap(coll1);
        Map<E, Integer> map2 = CollUtil.countMap(coll2);
        boolean isFirstSmaller = map1.size() <= map2.size();
        HashSet<E> elements = SetUtil.of(isFirstSmaller ? map1.keySet() : map2.keySet());
        ArrayList list = new ArrayList(isFirstSmaller ? coll1.size() : coll2.size());
        for (Object t : elements) {
            int amount = Math.min(map1.getOrDefault(t, 0), map2.getOrDefault(t, 0));
            for (int i = 0; i < amount; ++i) {
                list.add(t);
            }
        }
        return list;
    }

    private static <T> Collection<T> _disjunction(Collection<T> coll1, Collection<T> coll2) {
        if (CollUtil.isEmpty(coll1)) {
            if (CollUtil.isEmpty(coll2)) {
                return ListUtil.zero();
            }
            return coll2;
        }
        if (CollUtil.isEmpty(coll2)) {
            return coll1;
        }
        ArrayList result = new ArrayList(coll1.size() + coll2.size());
        Map<T, Integer> map1 = CollUtil.countMap(coll1);
        Map<T, Integer> map2 = CollUtil.countMap(coll2);
        HashSet<T> elements = SetUtil.of(map1.keySet());
        elements.addAll(map2.keySet());
        for (Object t : elements) {
            int amount = Math.abs(map1.getOrDefault(t, 0) - map2.getOrDefault(t, 0));
            for (int i = 0; i < amount; ++i) {
                result.add(t);
            }
        }
        return result;
    }
}

