/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.io.watch;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.watch.WatchKind;
import org.dromara.hutool.core.io.watch.WatchMonitor;
import org.dromara.hutool.core.io.watch.Watcher;
import org.dromara.hutool.core.net.url.URLUtil;

public class WatchUtil {
    public static WatchMonitor of(URL url, WatchEvent.Kind<?> ... events) {
        return WatchUtil.of(url, 0, events);
    }

    public static WatchMonitor of(URL url, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.of(URLUtil.toURI(url), maxDepth, events);
    }

    public static WatchMonitor of(URI uri, WatchEvent.Kind<?> ... events) {
        return WatchUtil.of(uri, 0, events);
    }

    public static WatchMonitor of(URI uri, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.of(Paths.get(uri), maxDepth, events);
    }

    public static WatchMonitor of(File file, WatchEvent.Kind<?> ... events) {
        return WatchUtil.of(file, 0, events);
    }

    public static WatchMonitor of(File file, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.of(file.toPath(), maxDepth, events);
    }

    public static WatchMonitor of(String path, WatchEvent.Kind<?> ... events) {
        return WatchUtil.of(path, 0, events);
    }

    public static WatchMonitor of(String path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchUtil.of(Paths.get(path, new String[0]), maxDepth, events);
    }

    public static WatchMonitor of(Path path, WatchEvent.Kind<?> ... events) {
        return WatchUtil.of(path, 0, events);
    }

    public static WatchMonitor of(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(path, maxDepth, events);
    }

    public static WatchMonitor ofAll(URL url, Watcher watcher) {
        return WatchUtil.ofAll(url, 0, watcher);
    }

    public static WatchMonitor ofAll(URL url, int maxDepth, Watcher watcher) {
        return WatchUtil.ofAll(URLUtil.toURI(url), maxDepth, watcher);
    }

    public static WatchMonitor ofAll(URI uri, Watcher watcher) {
        return WatchUtil.ofAll(uri, 0, watcher);
    }

    public static WatchMonitor ofAll(URI uri, int maxDepth, Watcher watcher) {
        return WatchUtil.ofAll(Paths.get(uri), maxDepth, watcher);
    }

    public static WatchMonitor ofAll(File file, Watcher watcher) {
        return WatchUtil.ofAll(file, 0, watcher);
    }

    public static WatchMonitor ofAll(File file, int maxDepth, Watcher watcher) {
        return WatchUtil.ofAll(file.toPath(), maxDepth, watcher);
    }

    public static WatchMonitor ofAll(String path, Watcher watcher) {
        return WatchUtil.ofAll(path, 0, watcher);
    }

    public static WatchMonitor ofAll(String path, int maxDepth, Watcher watcher) {
        return WatchUtil.ofAll(Paths.get(path, new String[0]), maxDepth, watcher);
    }

    public static WatchMonitor ofAll(Path path, Watcher watcher) {
        return WatchUtil.ofAll(path, 0, watcher);
    }

    public static WatchMonitor ofAll(Path path, int maxDepth, Watcher watcher) {
        WatchMonitor watchMonitor = WatchUtil.of(path, maxDepth, WatchKind.ALL);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public static WatchMonitor createModify(URL url, Watcher watcher) {
        return WatchUtil.createModify(url, 0, watcher);
    }

    public static WatchMonitor createModify(URL url, int maxDepth, Watcher watcher) {
        return WatchUtil.createModify(URLUtil.toURI(url), maxDepth, watcher);
    }

    public static WatchMonitor createModify(URI uri, Watcher watcher) {
        return WatchUtil.createModify(uri, 0, watcher);
    }

    public static WatchMonitor createModify(URI uri, int maxDepth, Watcher watcher) {
        return WatchUtil.createModify(Paths.get(uri), maxDepth, watcher);
    }

    public static WatchMonitor createModify(File file, Watcher watcher) {
        return WatchUtil.createModify(file, 0, watcher);
    }

    public static WatchMonitor createModify(File file, int maxDepth, Watcher watcher) {
        return WatchUtil.createModify(file.toPath(), maxDepth, watcher);
    }

    public static WatchMonitor createModify(String path, Watcher watcher) {
        return WatchUtil.createModify(path, 0, watcher);
    }

    public static WatchMonitor createModify(String path, int maxDepth, Watcher watcher) {
        return WatchUtil.createModify(Paths.get(path, new String[0]), maxDepth, watcher);
    }

    public static WatchMonitor createModify(Path path, Watcher watcher) {
        return WatchUtil.createModify(path, 0, watcher);
    }

    public static WatchMonitor createModify(Path path, int maxDepth, Watcher watcher) {
        WatchMonitor watchMonitor = WatchUtil.of(path, maxDepth, WatchKind.MODIFY.getValue());
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public static WatchKey register(Watchable watchable, WatchService watcher, WatchEvent.Kind<?> ... events) {
        try {
            return watchable.register(watcher, events);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

