/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.core.reflect.kotlin;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.bean.copier.ValueProvider;
import org.dromara.hutool.core.bean.copier.provider.MapValueProvider;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.reflect.kotlin.KCallable;
import org.dromara.hutool.core.reflect.kotlin.KClassImpl;
import org.dromara.hutool.core.reflect.kotlin.KParameter;

public class KClassUtil {
    private static final Class<? extends Annotation> META_DATA_CLASS = Opt.ofTry(() -> Class.forName("kotlin.Metadata")).get();
    public static final boolean IS_KOTLIN_ENABLE = null != META_DATA_CLASS;

    public static boolean isKotlinClass(Class<?> clazz) {
        return IS_KOTLIN_ENABLE && clazz.isAnnotationPresent(META_DATA_CLASS);
    }

    public static List<?> getConstructors(Class<?> targetType) {
        return KClassImpl.getConstructors(targetType);
    }

    public static List<KParameter> getParameters(Object kCallable) {
        return KCallable.getParameters(kCallable);
    }

    public static Object[] getParameterValues(Object kCallable, ValueProvider<String> valueProvider) {
        List<KParameter> parameters = KClassUtil.getParameters(kCallable);
        Object[] args = new Object[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            KParameter kParameter = parameters.get(i);
            args[i] = valueProvider.value(kParameter.getName(), kParameter.getType());
        }
        return args;
    }

    public static <T> T newInstance(Class<T> targetType, Map<String, ?> map) {
        return KClassUtil.newInstance(targetType, new MapValueProvider(map));
    }

    public static <T> T newInstance(Class<T> targetType, ValueProvider<String> valueProvider) {
        List<?> constructors = KClassUtil.getConstructors(targetType);
        RuntimeException exception = null;
        for (Object constructor : constructors) {
            Object[] parameterValues = KClassUtil.getParameterValues(constructor, valueProvider);
            try {
                return (T)KCallable.call(constructor, parameterValues);
            }
            catch (RuntimeException e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
        return null;
    }
}

