/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.dromara.hutool.core.util.RandomUtil;
import org.dromara.hutool.crypto.CryptoException;

public class SpecUtil {
    public static KeySpec createKeySpec(String algorithm, byte[] key) {
        try {
            if (algorithm.startsWith("DESede")) {
                if (null == key) {
                    key = RandomUtil.randomBytes(24);
                }
                return new DESedeKeySpec(key);
            }
            if (algorithm.startsWith("DES")) {
                if (null == key) {
                    key = RandomUtil.randomBytes(8);
                }
                return new DESKeySpec(key);
            }
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
        return new SecretKeySpec(key, algorithm);
    }

    public static PBEKeySpec createPBEKeySpec(char[] password) {
        if (null == password) {
            password = RandomUtil.randomString(32).toCharArray();
        }
        return new PBEKeySpec(password);
    }

    public static PBEParameterSpec createPBEParameterSpec(byte[] salt, int iterationCount) {
        return new PBEParameterSpec(salt, iterationCount);
    }
}

