/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.iter.ArrayIter;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.builder.Builder;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.sql.NamedSql;
import org.dromara.hutool.db.sql.SqlLog;
import org.dromara.hutool.db.sql.StatementWrapper;

public class StatementBuilder
implements Builder<StatementWrapper> {
    private static final long serialVersionUID = 1L;
    private SqlLog sqlLog;
    private Connection connection;
    private String sql;
    private Object[] params;
    private boolean returnGeneratedKey = true;

    public static StatementBuilder of() {
        return new StatementBuilder();
    }

    public StatementBuilder setSqlLog(SqlLog sqlLog) {
        this.sqlLog = sqlLog;
        return this;
    }

    public StatementBuilder setConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public StatementBuilder setSql(String sql) {
        this.sql = StrUtil.trim(sql);
        return this;
    }

    public StatementBuilder setParams(Object ... params) {
        this.params = params;
        return this;
    }

    public StatementBuilder setReturnGeneratedKey(boolean returnGeneratedKey) {
        this.returnGeneratedKey = returnGeneratedKey;
        return this;
    }

    @Override
    public StatementWrapper build() {
        try {
            return this._build();
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public StatementWrapper buildForBatch(Iterable<Object[]> paramsBatch) throws DbRuntimeException {
        StatementWrapper ps;
        Assert.notBlank(this.sql, "Sql String must be not blank!", new Object[0]);
        this.sqlLog.log(this.sql, paramsBatch);
        try {
            ps = StatementWrapper.of(this.connection.prepareStatement(this.sql));
            HashMap<Integer, Integer> nullTypeMap = new HashMap<Integer, Integer>();
            for (Object[] params : paramsBatch) {
                ps.fillParams(new ArrayIter<Object>(params), nullTypeMap);
                ps.addBatch();
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return ps;
    }

    public StatementWrapper buildForBatch(Iterable<String> fields, Entity ... entities) throws DbRuntimeException {
        StatementWrapper ps;
        Assert.notBlank(this.sql, "Sql String must be not blank!", new Object[0]);
        this.sqlLog.logForBatch(this.sql);
        try {
            ps = StatementWrapper.of(this.connection.prepareStatement(this.sql));
            HashMap<Integer, Integer> nullTypeMap = new HashMap<Integer, Integer>();
            for (Entity entity : entities) {
                ps.fillParams(MapUtil.valuesOfKeys(entity, fields), nullTypeMap);
                ps.addBatch();
            }
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return ps;
    }

    private StatementWrapper _build() throws SQLException {
        Assert.notBlank(this.sql, "Sql String must be not blank!", new Object[0]);
        if (ArrayUtil.isNotEmpty(this.params) && 1 == this.params.length && this.params[0] instanceof Map) {
            NamedSql namedSql = new NamedSql(this.sql, Convert.toMap(String.class, Object.class, this.params[0]));
            this.sql = namedSql.getSql();
            this.params = namedSql.getParams();
        }
        this.sqlLog.log(this.sql, ArrayUtil.isEmpty(this.params) ? null : this.params);
        PreparedStatement ps = this.returnGeneratedKey && StrUtil.startWithIgnoreCase(this.sql, "insert") ? this.connection.prepareStatement(this.sql, 1) : this.connection.prepareStatement(this.sql);
        return StatementWrapper.of(ps).fillArrayParam(this.params);
    }
}

