/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.pinyin.engine.pinyin4j;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.extra.pinyin.PinyinException;
import org.dromara.hutool.extra.pinyin.engine.PinyinEngine;

public class Pinyin4jEngine
implements PinyinEngine {
    HanyuPinyinOutputFormat format;

    public Pinyin4jEngine() {
        this(null);
    }

    public Pinyin4jEngine(HanyuPinyinOutputFormat format) {
        this.init(format);
    }

    public void init(HanyuPinyinOutputFormat format) {
        if (null == format) {
            format = new HanyuPinyinOutputFormat();
            format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
            format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
            format.setVCharType(HanyuPinyinVCharType.WITH_V);
        }
        this.format = format;
    }

    @Override
    public String getPinyin(char c) {
        String result;
        try {
            String[] results = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)this.format);
            result = ArrayUtil.isEmpty(results) ? String.valueOf(c) : results[0];
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            result = String.valueOf(c);
        }
        return result;
    }

    @Override
    public String getPinyin(String str, String separator) {
        StringBuilder result = new StringBuilder();
        boolean isFirst = true;
        int strLen = str.length();
        try {
            for (int i = 0; i < strLen; ++i) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    result.append(separator);
                }
                String[] pinyinStringArray = PinyinHelper.toHanyuPinyinStringArray((char)str.charAt(i), (HanyuPinyinOutputFormat)this.format);
                if (ArrayUtil.isEmpty(pinyinStringArray)) {
                    result.append(str.charAt(i));
                    continue;
                }
                result.append(pinyinStringArray[0]);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            throw new PinyinException(e);
        }
        return result.toString();
    }
}

