/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.template.engine.enjoy;

import com.jfinal.template.Engine;
import com.jfinal.template.source.FileSourceFactory;
import com.jfinal.template.source.ISourceFactory;
import java.io.File;
import org.dromara.hutool.core.data.id.IdUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.extra.template.Template;
import org.dromara.hutool.extra.template.TemplateConfig;
import org.dromara.hutool.extra.template.engine.TemplateEngine;
import org.dromara.hutool.extra.template.engine.enjoy.EnjoyTemplate;

public class EnjoyEngine
implements TemplateEngine {
    private Engine engine;
    private TemplateConfig.ResourceMode resourceMode;

    public EnjoyEngine() {
    }

    public EnjoyEngine(TemplateConfig config) {
        this.init(config);
    }

    public EnjoyEngine(Engine engine) {
        this.init(engine);
    }

    @Override
    public TemplateEngine init(TemplateConfig config) {
        if (null == config) {
            config = TemplateConfig.DEFAULT;
        }
        this.resourceMode = config.getResourceMode();
        this.init(EnjoyEngine.createEngine(config));
        return this;
    }

    private void init(Engine engine) {
        this.engine = engine;
    }

    @Override
    public Template getTemplate(String resource) {
        if (null == this.engine) {
            this.init(TemplateConfig.DEFAULT);
        }
        if (ObjUtil.equals((Object)TemplateConfig.ResourceMode.STRING, (Object)this.resourceMode)) {
            return EnjoyTemplate.wrap(this.engine.getTemplateByString(resource));
        }
        return EnjoyTemplate.wrap(this.engine.getTemplate(resource));
    }

    @Override
    public Engine getRaw() {
        return this.engine;
    }

    private static Engine createEngine(TemplateConfig config) {
        Engine engine = Engine.create((String)("Hutool-Enjoy-Engine-" + IdUtil.fastSimpleUUID()));
        engine.setEncoding(config.getCharsetStr());
        switch (config.getResourceMode()) {
            case STRING: {
                break;
            }
            case CLASSPATH: {
                engine.setToClassPathSourceFactory();
                engine.setBaseTemplatePath(config.getPath());
                break;
            }
            case FILE: {
                engine.setSourceFactory((ISourceFactory)new FileSourceFactory());
                engine.setBaseTemplatePath(config.getPath());
                break;
            }
            case WEB_ROOT: {
                engine.setSourceFactory((ISourceFactory)new FileSourceFactory());
                File root = FileUtil.file(FileUtil.getWebRoot(), config.getPath());
                engine.setBaseTemplatePath(FileUtil.getAbsolutePath(root));
                break;
            }
        }
        return engine;
    }
}

