/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.xml;

import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.dromara.hutool.core.exception.HutoolException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public class JAXBUtil {
    public static String beanToXml(Object bean) {
        return JAXBUtil.beanToXml(bean, CharsetUtil.UTF_8, true);
    }

    public static String beanToXml(Object bean, Charset charset, boolean format) {
        StringWriter writer;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{bean.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)format);
            marshaller.setProperty("jaxb.encoding", (Object)charset.name());
            writer = new StringWriter();
            marshaller.marshal(bean, (Writer)writer);
        }
        catch (Exception e) {
            throw new HutoolException("convertToXml \u9519\u8bef\uff1a" + e.getMessage(), e);
        }
        return writer.toString();
    }

    public static <T> T xmlToBean(String xml, Class<T> c) {
        return JAXBUtil.xmlToBean(StrUtil.getReader(xml), c);
    }

    public static <T> T xmlToBean(File file, Charset charset, Class<T> c) {
        return JAXBUtil.xmlToBean(FileUtil.getReader(file, charset), c);
    }

    public static <T> T xmlToBean(Reader reader, Class<T> c) {
        Object object;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{c});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            object = unmarshaller.unmarshal(reader);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("convertToJava2 \u9519\u8bef\uff1a" + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly(reader);
                throw throwable;
            }
        }
        IoUtil.closeQuietly(reader);
        return (T)object;
    }
}

